"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertContextMenu = exports.AddExceptionFlyoutWrapper = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _fp = require("lodash/fp");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _objectUtils = require("@kbn/object-utils");
var _use_rule_with_fallback = require("../../../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _header_actions = require("../../../../common/components/header_actions");
var _helpers = require("../../../../helpers");
var _use_osquery_context_action_item = require("../../osquery/use_osquery_context_action_item");
var _osquery_flyout = require("../../osquery/osquery_flyout");
var _helpers2 = require("../../../../detection_engine/rule_exceptions/utils/helpers");
var _user_privileges = require("../../../../common/components/user_privileges");
var _styles = require("../../../../timelines/components/timeline/styles");
var _add_exception_flyout = require("../../../../detection_engine/rule_exceptions/components/add_exception_flyout");
var i18n = _interopRequireWildcard(require("../translations"));
var _store = require("../../../../common/store");
var _use_query = require("../../../containers/detection_engine/alerts/use_query");
var _constants = require("../../../containers/detection_engine/alerts/constants");
var _use_signal_index = require("../../../containers/detection_engine/alerts/use_signal_index");
var _event_filters_flyout = require("../../../../management/pages/event_filters/view/components/event_filters_flyout");
var _use_alerts_actions = require("./use_alerts_actions");
var _use_add_exception_flyout = require("./use_add_exception_flyout");
var _use_add_exception_actions = require("./use_add_exception_actions");
var _use_event_filter_modal = require("./use_event_filter_modal");
var _timeline = require("../../../../../common/types/timeline");
var _translations2 = require("../../../../timelines/components/timeline/body/translations");
var _selectors = require("../../../../timelines/store/selectors");
var _use_event_filter_action = require("./use_event_filter_action");
var _use_add_to_case_actions = require("./use_add_to_case_actions");
var _use_alert_tags_actions = require("./use_alert_tags_actions");
var _use_alert_assignees_actions = require("./use_alert_assignees_actions");
var _defaults = require("../../../../timelines/store/defaults");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_table/timeline_actions/alert_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertContextMenuComponent = ({
  ariaLabel = i18n.MORE_ACTIONS,
  ariaRowindex,
  columnValues,
  disabled,
  ecsRowData,
  onRuleChange,
  scopeId,
  refetch
}) => {
  var _ecsRowData$kibana2, _ecsRowData$kibana2$a, _ecsRowData$kibana2$a2, _ecsRowData$kibana3, _ecsRowData$kibana3$a, _ecsRowData$kibana3$a2, _ecsRowData$kibana4, _ecsRowData$kibana4$a, _ecsRowData$kibana4$a2, _ecsRowData$kibana5, _ecsRowData$kibana5$a, _ecsRowData$kibanaAl, _ecsRowData$kibanaAl2, _ecsRowData$signal, _ecsRowData$signal$ru, _ecsRowData$kibanaAl3, _ecsRowData$kibanaAl4, _ecsRowData$signal2, _ecsRowData$signal2$r;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const [isOsqueryFlyoutOpen, setOsqueryFlyoutOpen] = (0, _react.useState)(false);
  const onMenuItemClick = (0, _react.useCallback)(() => {
    setPopover(false);
  }, []);
  const {
    activeTab
  } = (0, _reactRedux.useSelector)(state => {
    var _selectTimelineById;
    return (_selectTimelineById = (0, _selectors.selectTimelineById)(state, _timeline.TimelineId.active)) !== null && _selectTimelineById !== void 0 ? _selectTimelineById : _defaults.timelineDefaults;
  });
  const getGlobalQueries = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuery(), []);
  const getTimelineQuery = (0, _react.useMemo)(() => _store.inputsSelectors.timelineQueryByIdSelectorFactory(), []);
  const globalQuery = (0, _reactRedux.useSelector)(state => getGlobalQueries(state));
  const timelineQuery = (0, _reactRedux.useSelector)(state => getTimelineQuery(state, `${_timeline.TimelineId.active}-${activeTab}`));
  const getAlertId = () => {
    var _ecsRowData$kibana;
    return ecsRowData !== null && ecsRowData !== void 0 && (_ecsRowData$kibana = ecsRowData.kibana) !== null && _ecsRowData$kibana !== void 0 && _ecsRowData$kibana.alert ? ecsRowData === null || ecsRowData === void 0 ? void 0 : ecsRowData._id : null;
  };
  const alertId = getAlertId();
  const ruleId = (0, _fp.get)(0, ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$kibana2 = ecsRowData.kibana) === null || _ecsRowData$kibana2 === void 0 ? void 0 : (_ecsRowData$kibana2$a = _ecsRowData$kibana2.alert) === null || _ecsRowData$kibana2$a === void 0 ? void 0 : (_ecsRowData$kibana2$a2 = _ecsRowData$kibana2$a.rule) === null || _ecsRowData$kibana2$a2 === void 0 ? void 0 : _ecsRowData$kibana2$a2.uuid);
  const ruleRuleId = (0, _fp.get)(0, ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$kibana3 = ecsRowData.kibana) === null || _ecsRowData$kibana3 === void 0 ? void 0 : (_ecsRowData$kibana3$a = _ecsRowData$kibana3.alert) === null || _ecsRowData$kibana3$a === void 0 ? void 0 : (_ecsRowData$kibana3$a2 = _ecsRowData$kibana3$a.rule) === null || _ecsRowData$kibana3$a2 === void 0 ? void 0 : _ecsRowData$kibana3$a2.rule_id);
  const ruleName = (0, _fp.get)(0, ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$kibana4 = ecsRowData.kibana) === null || _ecsRowData$kibana4 === void 0 ? void 0 : (_ecsRowData$kibana4$a = _ecsRowData$kibana4.alert) === null || _ecsRowData$kibana4$a === void 0 ? void 0 : (_ecsRowData$kibana4$a2 = _ecsRowData$kibana4$a.rule) === null || _ecsRowData$kibana4$a2 === void 0 ? void 0 : _ecsRowData$kibana4$a2.name);
  const flattenedEcsData = (0, _react.useMemo)(() => {
    const flattened = (0, _objectUtils.flattenObject)(ecsRowData);
    return Object.entries(flattened).map(([key, value]) => ({
      field: key,
      value: value
    }));
  }, [ecsRowData]);
  const {
    addToCaseActionItems
  } = (0, _use_add_to_case_actions.useAddToCaseActions)({
    ecsData: ecsRowData,
    nonEcsData: flattenedEcsData,
    onMenuItemClick,
    ariaLabel: (0, _translations2.ATTACH_ALERT_TO_CASE_FOR_ROW)({
      ariaRowindex,
      columnValues
    }),
    refetch
  });
  const {
    loading: endpointPrivilegesLoading,
    canWriteEventFilters
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const canCreateEndpointEventFilters = (0, _react.useMemo)(() => !endpointPrivilegesLoading && canWriteEventFilters, [canWriteEventFilters, endpointPrivilegesLoading]);
  const alertStatus = (0, _fp.get)(0, ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$kibana5 = ecsRowData.kibana) === null || _ecsRowData$kibana5 === void 0 ? void 0 : (_ecsRowData$kibana5$a = _ecsRowData$kibana5.alert) === null || _ecsRowData$kibana5$a === void 0 ? void 0 : _ecsRowData$kibana5$a.workflow_status);
  const isEvent = (0, _react.useMemo)(() => {
    var _ecsRowData$event;
    return (0, _lodash.indexOf)((_ecsRowData$event = ecsRowData.event) === null || _ecsRowData$event === void 0 ? void 0 : _ecsRowData$event.kind, 'event') !== -1;
  }, [ecsRowData]);
  const isAgentEndpoint = (0, _react.useMemo)(() => {
    var _ecsRowData$agent, _ecsRowData$agent$typ;
    return (_ecsRowData$agent = ecsRowData.agent) === null || _ecsRowData$agent === void 0 ? void 0 : (_ecsRowData$agent$typ = _ecsRowData$agent.type) === null || _ecsRowData$agent$typ === void 0 ? void 0 : _ecsRowData$agent$typ.includes('endpoint');
  }, [ecsRowData]);
  const isEndpointEvent = (0, _react.useMemo)(() => isEvent && isAgentEndpoint, [isEvent, isAgentEndpoint]);
  const isAlertSourceEndpoint = (0, _react.useMemo)(() => {
    const eventModules = (0, _fp.getOr)([], 'kibana.alert.original_event.module', ecsRowData);
    const kinds = (0, _fp.getOr)([], 'kibana.alert.original_event.kind', ecsRowData);
    return eventModules.includes('endpoint') && kinds.includes('alert');
  }, [ecsRowData]);
  const scopeIdAllowsAddEndpointEventFilter = (0, _react.useMemo)(() => scopeId === _securitysolutionDataTable.TableId.hostsPageEvents || scopeId === _securitysolutionDataTable.TableId.usersPageEvents, [scopeId]);
  const onButtonClick = (0, _react.useCallback)(() => {
    setPopover(current => !current);
  }, []);
  const closePopover = (0, _react.useCallback)(() => {
    setPopover(false);
  }, []);
  const refetchAll = (0, _react.useCallback)(() => {
    const refetchQuery = newQueries => {
      newQueries.forEach(q => q.refetch && q.refetch());
    };
    if ((0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '')) {
      refetchQuery([timelineQuery]);
    } else {
      refetchQuery(globalQuery);
    }
    if (refetch) refetch();
  }, [scopeId, globalQuery, timelineQuery, refetch]);
  const ruleIndex = (_ecsRowData$kibanaAl = (_ecsRowData$kibanaAl2 = ecsRowData['kibana.alert.rule.parameters']) === null || _ecsRowData$kibanaAl2 === void 0 ? void 0 : _ecsRowData$kibanaAl2.index) !== null && _ecsRowData$kibanaAl !== void 0 ? _ecsRowData$kibanaAl : ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$signal = ecsRowData.signal) === null || _ecsRowData$signal === void 0 ? void 0 : (_ecsRowData$signal$ru = _ecsRowData$signal.rule) === null || _ecsRowData$signal$ru === void 0 ? void 0 : _ecsRowData$signal$ru.index;
  const ruleDataViewId = (_ecsRowData$kibanaAl3 = (_ecsRowData$kibanaAl4 = ecsRowData['kibana.alert.rule.parameters']) === null || _ecsRowData$kibanaAl4 === void 0 ? void 0 : _ecsRowData$kibanaAl4.data_view_id) !== null && _ecsRowData$kibanaAl3 !== void 0 ? _ecsRowData$kibanaAl3 : ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$signal2 = ecsRowData.signal) === null || _ecsRowData$signal2 === void 0 ? void 0 : (_ecsRowData$signal2$r = _ecsRowData$signal2.rule) === null || _ecsRowData$signal2$r === void 0 ? void 0 : _ecsRowData$signal2$r.data_view_id;
  const {
    exceptionFlyoutType,
    openAddExceptionFlyout,
    onAddExceptionCancel,
    onAddExceptionConfirm,
    onAddExceptionTypeClick
  } = (0, _use_add_exception_flyout.useExceptionFlyout)({
    refetch: refetchAll,
    onRuleChange,
    isActiveTimelines: (0, _helpers.isActiveTimeline)(scopeId !== null && scopeId !== void 0 ? scopeId : '')
  });
  const {
    closeAddEventFilterModal,
    isAddEventFilterModalOpen,
    onAddEventFilterClick
  } = (0, _use_event_filter_modal.useEventFilterModal)();
  const {
    actionItems: statusActionItems,
    panels: statusActionPanels
  } = (0, _use_alerts_actions.useAlertsActions)({
    alertStatus,
    eventId: ecsRowData === null || ecsRowData === void 0 ? void 0 : ecsRowData._id,
    scopeId,
    refetch: refetchAll,
    closePopover
  });
  const handleOnAddExceptionTypeClick = (0, _react.useCallback)(type => {
    onAddExceptionTypeClick(type);
    closePopover();
  }, [closePopover, onAddExceptionTypeClick]);
  const handleOnAddEventFilterClick = (0, _react.useCallback)(() => {
    onAddEventFilterClick();
    closePopover();
  }, [closePopover, onAddEventFilterClick]);
  const {
    exceptionActionItems
  } = (0, _use_add_exception_actions.useAlertExceptionActions)({
    isEndpointAlert: isAlertSourceEndpoint,
    onAddExceptionTypeClick: handleOnAddExceptionTypeClick
  });
  const {
    eventFilterActionItems
  } = (0, _use_event_filter_action.useEventFilterAction)({
    onAddEventFilterClick: handleOnAddEventFilterClick,
    disabled: !isEndpointEvent || !scopeIdAllowsAddEndpointEventFilter,
    tooltipMessage: !scopeIdAllowsAddEndpointEventFilter ? i18n.ACTION_ADD_EVENT_FILTER_DISABLED_TOOLTIP : undefined
  });
  const agentId = (0, _react.useMemo)(() => {
    var _ecsRowData$agent2;
    return (0, _fp.get)(0, ecsRowData === null || ecsRowData === void 0 ? void 0 : (_ecsRowData$agent2 = ecsRowData.agent) === null || _ecsRowData$agent2 === void 0 ? void 0 : _ecsRowData$agent2.id);
  }, [ecsRowData]);
  const handleOnOsqueryClick = (0, _react.useCallback)(() => {
    setOsqueryFlyoutOpen(prevValue => !prevValue);
    setPopover(false);
  }, []);
  const {
    osqueryActionItems
  } = (0, _use_osquery_context_action_item.useOsqueryContextActionItem)({
    handleClick: handleOnOsqueryClick
  });
  const {
    alertTagsItems,
    alertTagsPanels
  } = (0, _use_alert_tags_actions.useAlertTagsActions)({
    closePopover,
    ecsRowData,
    refetch: refetchAll
  });
  const {
    alertAssigneesItems,
    alertAssigneesPanels
  } = (0, _use_alert_assignees_actions.useAlertAssigneesActions)({
    closePopover,
    ecsRowData,
    refetch: refetchAll
  });
  const items = (0, _react.useMemo)(() => !isEvent && ruleId ? [...addToCaseActionItems, ...statusActionItems, ...alertTagsItems, ...alertAssigneesItems, ...exceptionActionItems, ...(agentId ? osqueryActionItems : [])] : [...addToCaseActionItems, ...(canCreateEndpointEventFilters ? eventFilterActionItems : []), ...(agentId ? osqueryActionItems : [])], [isEvent, ruleId, addToCaseActionItems, statusActionItems, exceptionActionItems, agentId, osqueryActionItems, eventFilterActionItems, canCreateEndpointEventFilters, alertTagsItems, alertAssigneesItems]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    items
  }, ...alertTagsPanels, ...alertAssigneesPanels, ...statusActionPanels], [items, alertTagsPanels, alertAssigneesPanels, statusActionPanels]);
  const button = (0, _react.useMemo)(() => {
    const hasItems = !!items.length;
    const tooltipContent = hasItems ? i18n.MORE_ACTIONS : i18n.INSUFFICIENT_PRIVILEGES;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: tooltipContent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": ariaLabel,
      "data-test-subj": "timeline-context-menu-button",
      size: "s",
      iconType: "boxesHorizontal",
      "data-popover-open": isPopoverOpen,
      onClick: onButtonClick,
      isDisabled: disabled || !hasItems,
      color: isPopoverOpen ? 'primary' : 'text',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 9
      }
    }));
  }, [ariaLabel, isPopoverOpen, onButtonClick, disabled, items.length]);
  const osqueryFlyout = (0, _react.useMemo)(() => {
    return /*#__PURE__*/_react.default.createElement(_osquery_flyout.OsqueryFlyout, {
      agentId: agentId,
      defaultValues: alertId ? {
        alertIds: [alertId]
      } : undefined,
      onClose: handleOnOsqueryClick,
      ecsData: ecsRowData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 301,
        columnNumber: 7
      }
    });
  }, [agentId, alertId, ecsRowData, handleOnOsqueryClick]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    key: "actions-context-menu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTdContent, {
    textAlign: "center",
    width: _header_actions.DEFAULT_ACTION_BUTTON_WIDTH,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "singlePanel",
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    repositionOnScroll: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    size: "s",
    initialPanelId: 0,
    panels: panels,
    "data-test-subj": "actions-context-menu",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 13
    }
  })))), openAddExceptionFlyout && ruleId && ruleRuleId && ruleName != null && (ecsRowData === null || ecsRowData === void 0 ? void 0 : ecsRowData._id) != null && /*#__PURE__*/_react.default.createElement(AddExceptionFlyoutWrapper, {
    ruleId: ruleId,
    ruleRuleId: ruleRuleId,
    ruleIndices: ruleIndex,
    ruleDataViewId: ruleDataViewId,
    ruleName: ruleName,
    exceptionListType: exceptionFlyoutType,
    eventId: ecsRowData === null || ecsRowData === void 0 ? void 0 : ecsRowData._id,
    onCancel: onAddExceptionCancel,
    onConfirm: onAddExceptionConfirm,
    alertStatus: alertStatus,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 11
    }
  }), isAddEventFilterModalOpen && ecsRowData != null && /*#__PURE__*/_react.default.createElement(_event_filters_flyout.EventFiltersFlyout, {
    data: ecsRowData,
    onCancel: closeAddEventFilterModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 351,
      columnNumber: 9
    }
  }), isOsqueryFlyoutOpen && agentId && ecsRowData != null && osqueryFlyout);
};
const AlertContextMenu = exports.AlertContextMenu = /*#__PURE__*/_react.default.memo(AlertContextMenuComponent);
/**
 * This component exists to fetch needed data outside of the AddExceptionFlyout
 * Due to the conditional nature of the flyout and how we use the `ecsData` field,
 * we cannot use the fetch hook within the flyout component itself
 */
const AddExceptionFlyoutWrapper = ({
  ruleId,
  ruleRuleId,
  ruleIndices,
  ruleDataViewId,
  ruleName,
  exceptionListType,
  eventId,
  onCancel,
  onConfirm,
  alertStatus
}) => {
  var _enrichedAlert$kibana3;
  const {
    loading: isSignalIndexLoading,
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    rule: maybeRule,
    loading: isRuleLoading
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const {
    loading: isLoadingAlertData,
    data
  } = (0, _use_query.useQueryAlerts)({
    query: (0, _helpers2.buildGetAlertByIdQuery)(eventId),
    indexName: signalIndexName,
    queryName: _constants.ALERTS_QUERY_NAMES.ADD_EXCEPTION_FLYOUT
  });
  const enrichedAlert = (0, _react.useMemo)(() => {
    if (isLoadingAlertData === false) {
      const hit = data === null || data === void 0 ? void 0 : data.hits.hits[0];
      if (!hit) {
        return undefined;
      }
      const {
        _id,
        _index,
        _source
      } = hit;
      return {
        ..._source,
        _id,
        _index
      };
    }
  }, [data === null || data === void 0 ? void 0 : data.hits.hits, isLoadingAlertData]);

  /**
   * This should be re-visited after UEBA work is merged
   */
  const memoRuleIndices = (0, _react.useMemo)(() => {
    var _enrichedAlert$kibana, _enrichedAlert$signal, _enrichedAlert$signal2;
    if (enrichedAlert != null && ((_enrichedAlert$kibana = enrichedAlert['kibana.alert.rule.parameters']) === null || _enrichedAlert$kibana === void 0 ? void 0 : _enrichedAlert$kibana.index) != null) {
      return Array.isArray(enrichedAlert['kibana.alert.rule.parameters'].index) ? enrichedAlert['kibana.alert.rule.parameters'].index : [enrichedAlert['kibana.alert.rule.parameters'].index];
    } else if (enrichedAlert != null && (enrichedAlert === null || enrichedAlert === void 0 ? void 0 : (_enrichedAlert$signal = enrichedAlert.signal) === null || _enrichedAlert$signal === void 0 ? void 0 : (_enrichedAlert$signal2 = _enrichedAlert$signal.rule) === null || _enrichedAlert$signal2 === void 0 ? void 0 : _enrichedAlert$signal2.index) != null) {
      return Array.isArray(enrichedAlert.signal.rule.index) ? enrichedAlert.signal.rule.index : [enrichedAlert.signal.rule.index];
    }
    return ruleIndices;
  }, [enrichedAlert, ruleIndices]);
  const memoDataViewId = (0, _react.useMemo)(() => {
    var _enrichedAlert$kibana2;
    if (enrichedAlert != null && ((_enrichedAlert$kibana2 = enrichedAlert['kibana.alert.rule.parameters']) === null || _enrichedAlert$kibana2 === void 0 ? void 0 : _enrichedAlert$kibana2.data_view_id) != null) {
      return enrichedAlert['kibana.alert.rule.parameters'].data_view_id;
    }
    return ruleDataViewId;
  }, [enrichedAlert, ruleDataViewId]);
  const memoRule = (0, _react.useMemo)(() => {
    if (maybeRule) {
      return [maybeRule];
    }
    return null;
  }, [maybeRule]);
  const ruleType = enrichedAlert === null || enrichedAlert === void 0 ? void 0 : (_enrichedAlert$kibana3 = enrichedAlert['kibana.alert.rule.parameters']) === null || _enrichedAlert$kibana3 === void 0 ? void 0 : _enrichedAlert$kibana3.type;
  const isAlertWithoutIndex = ruleType === 'esql' || ruleType === 'machine_learning';
  const isWaitingForIndexOrDataView = !isAlertWithoutIndex && memoRuleIndices == null && memoDataViewId == null;
  const isLoading = isLoadingAlertData && isSignalIndexLoading || enrichedAlert == null || isWaitingForIndexOrDataView;
  if (isLoading || isRuleLoading) return null;
  return /*#__PURE__*/_react.default.createElement(_add_exception_flyout.AddExceptionFlyout, {
    rules: memoRule,
    isEndpointItem: exceptionListType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT,
    alertData: enrichedAlert,
    isAlertDataLoading: isLoading || isRuleLoading,
    alertStatus: alertStatus,
    isBulkAction: false,
    showAlertCloseOptions: true,
    onCancel: onCancel,
    onConfirm: onConfirm,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 463,
      columnNumber: 5
    }
  });
};
exports.AddExceptionFlyoutWrapper = AddExceptionFlyoutWrapper;