"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeverityLevelPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _header_section = require("../../../../common/components/header_section");
var _inspect = require("../../../../common/components/inspect");
var _use_summary_chart_data = require("../alerts_summary_charts_panel/use_summary_chart_data");
var _aggregations = require("../alerts_summary_charts_panel/aggregations");
var _helpers = require("./helpers");
var _severity_level_chart = require("./severity_level_chart");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detections/components/alerts_kpis/severity_level_panel/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SEVERITY_DONUT_CHART_ID = 'alerts-summary-severity-donut';

/**
 * Renders a table and a donut chart showing alerts grouped by severity levels.
 * The component is used in the alerts page as well as in EASE alert summary page.
 */
const SeverityLevelPanel = ({
  filters,
  query,
  signalIndexName,
  runtimeMappings,
  addFilter,
  skip,
  showCellActions = true
}) => {
  const uniqueQueryId = (0, _react.useMemo)(() => `${SEVERITY_DONUT_CHART_ID}-${(0, _uuid.v4)()}`, []);
  const {
    items,
    isLoading
  } = (0, _use_summary_chart_data.useSummaryChartData)({
    aggregations: _aggregations.severityAggregations,
    filters,
    query,
    signalIndexName,
    runtimeMappings,
    skip,
    uniqueQueryId
  });
  const data = (0, _react.useMemo)(() => (0, _helpers.getIsAlertsBySeverityData)(items) ? items : [], [items]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    "data-test-subj": "severty-level-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    id: uniqueQueryId,
    inspectTitle: i18n.SEVERITY_LEVELS_TITLE,
    outerDirection: "row",
    title: i18n.SEVERITY_LEVELS_TITLE,
    titleSize: "xs",
    hideSubtitle: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_severity_level_chart.SeverityLevelChart, {
    data: data,
    isLoading: isLoading,
    addFilter: addFilter,
    showCellActions: showCellActions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })));
};
exports.SeverityLevelPanel = SeverityLevelPanel;
SeverityLevelPanel.displayName = 'SeverityLevelPanel';