"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInvalidateFetchRulesSnoozeSettingsQuery = exports.useFetchRulesSnoozeSettingsQuery = void 0;
var _common = require("@kbn/alerting-plugin/common");
var _reactQuery = require("@tanstack/react-query");
var _react = require("react");
var _api = require("../api");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_RULE_SNOOZE_SETTINGS_QUERY_KEY = ['POST', _common.INTERNAL_ALERTING_API_FIND_RULES_PATH];

/**
 * A wrapper around useQuery provides default values to the underlying query,
 * like query key, abortion signal.
 *
 * @param queryArgs - fetch rule snoozing settings ids
 * @param queryOptions - react-query options
 * @returns useQuery result
 */
const useFetchRulesSnoozeSettingsQuery = (ids, queryOptions) => {
  return (0, _reactQuery.useQuery)([...FETCH_RULE_SNOOZE_SETTINGS_QUERY_KEY, ...ids], ({
    signal
  }) => (0, _api.fetchRulesSnoozeSettings)({
    ids,
    signal
  }), {
    ..._constants.DEFAULT_QUERY_OPTIONS,
    ...queryOptions
  });
};

/**
 * We should use this hook to invalidate the cache. For example, rule
 * snooze modification should lead to cache invalidation.
 *
 * @returns A rules cache invalidation callback
 */
exports.useFetchRulesSnoozeSettingsQuery = useFetchRulesSnoozeSettingsQuery;
const useInvalidateFetchRulesSnoozeSettingsQuery = () => {
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _react.useCallback)(() => {
    /**
     * Invalidate all queries that start with FIND_RULES_QUERY_KEY. This
     * includes the in-memory query cache and paged query cache.
     */
    return queryClient.invalidateQueries(FETCH_RULE_SNOOZE_SETTINGS_QUERY_KEY, {
      refetchType: 'active'
    });
  }, [queryClient]);
};
exports.useInvalidateFetchRulesSnoozeSettingsQuery = useInvalidateFetchRulesSnoozeSettingsQuery;