"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBootstrapPrebuiltRulesMutation = exports.BOOTSTRAP_PREBUILT_RULES_KEY = void 0;
var _reactQuery = require("@tanstack/react-query");
var _detection_engine = require("../../../../../../common/api/detection_engine");
var _constants = require("../../../../../../common/detection_engine/constants");
var _api = require("../../api");
var _use_fetch_prebuilt_rules_install_review_query = require("./use_fetch_prebuilt_rules_install_review_query");
var _use_fetch_prebuilt_rules_status_query = require("./use_fetch_prebuilt_rules_status_query");
var _use_fetch_prebuilt_rules_upgrade_review_query = require("./use_fetch_prebuilt_rules_upgrade_review_query");
var _use_find_rules_query = require("../use_find_rules_query");
var _use_fetch_prebuilt_rule_base_version_query = require("./use_fetch_prebuilt_rule_base_version_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BOOTSTRAP_PREBUILT_RULES_KEY = exports.BOOTSTRAP_PREBUILT_RULES_KEY = ['POST', _detection_engine.BOOTSTRAP_PREBUILT_RULES_URL];
const useBootstrapPrebuiltRulesMutation = options => {
  const invalidatePrePackagedRulesStatus = (0, _use_fetch_prebuilt_rules_status_query.useInvalidateFetchPrebuiltRulesStatusQuery)();
  const invalidatePrebuiltRulesInstallReview = (0, _use_fetch_prebuilt_rules_install_review_query.useInvalidateFetchPrebuiltRulesInstallReviewQuery)();
  const invalidatePrebuiltRulesUpdateReview = (0, _use_fetch_prebuilt_rules_upgrade_review_query.useInvalidateFetchPrebuiltRulesUpgradeReviewQuery)();
  const invalidateFindRulesQuery = (0, _use_find_rules_query.useInvalidateFindRulesQuery)();
  const invalidateFetchPrebuiltRuleBaseVerison = (0, _use_fetch_prebuilt_rule_base_version_query.useInvalidateFetchPrebuiltRuleBaseVersionQuery)();
  return (0, _reactQuery.useMutation)(() => (0, _api.bootstrapPrebuiltRules)(), {
    ...options,
    mutationKey: BOOTSTRAP_PREBUILT_RULES_KEY,
    onSuccess: (...args) => {
      var _response$packages$fi, _response$rules, _response$rules2, _response$rules3;
      const response = args[0];

      // 'installed' means that the package was installed or updated to a newer version
      const hasInstalledNewPackageVersion = ((_response$packages$fi = response.packages.find(pkg => pkg.name === _constants.PREBUILT_RULES_PACKAGE_NAME)) === null || _response$packages$fi === void 0 ? void 0 : _response$packages$fi.status) === 'installed';
      if (hasInstalledNewPackageVersion) {
        // Invalidate other pre-packaged rules related queries. We need to do
        // that only in case the prebuilt rules package was installed indicating
        // that there might be new rules to install.
        invalidatePrePackagedRulesStatus();
        invalidatePrebuiltRulesInstallReview();
        invalidatePrebuiltRulesUpdateReview();
        invalidateFetchPrebuiltRuleBaseVerison();
      }
      const hasRuleUpdates = ((_response$rules = response.rules) === null || _response$rules === void 0 ? void 0 : _response$rules.deleted) || ((_response$rules2 = response.rules) === null || _response$rules2 === void 0 ? void 0 : _response$rules2.installed) || ((_response$rules3 = response.rules) === null || _response$rules3 === void 0 ? void 0 : _response$rules3.updated);
      if (hasRuleUpdates) {
        invalidateFindRulesQuery();
      }
      if (options !== null && options !== void 0 && options.onSuccess) {
        options.onSuccess(...args);
      }
    }
  });
};
exports.useBootstrapPrebuiltRulesMutation = useBootstrapPrebuiltRulesMutation;