"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.kueryValidatorFactory = kueryValidatorFactory;
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function kueryValidatorFactory() {
  return (...args) => {
    const [{
      path,
      value
    }] = args;
    if ((0, _lodash.isEmpty)(value.query.query) || value.query.language !== 'kuery') {
      return;
    }
    try {
      (0, _esQuery.fromKueryExpression)(value.query.query);
    } catch (err) {
      return {
        code: 'ERR_FIELD_FORMAT',
        path,
        message: _i18n.i18n.translate('xpack.securitySolution.detectionEngine.createRule.stepDefineRule.customQueryFieldInvalidError', {
          defaultMessage: 'The KQL is invalid'
        })
      };
    }
  };
}