"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isIndexNotFoundError = exports.isAbortError = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isIndexNotFoundError = error => {
  var _castError$attributes, _castError$attributes2, _castError$attributes3, _castError$attributes4, _castError$attributes5;
  const castError = error;
  return ((_castError$attributes = castError.attributes) === null || _castError$attributes === void 0 ? void 0 : (_castError$attributes2 = _castError$attributes.caused_by) === null || _castError$attributes2 === void 0 ? void 0 : _castError$attributes2.type) === 'index_not_found_exception' || ((_castError$attributes3 = castError.attributes) === null || _castError$attributes3 === void 0 ? void 0 : (_castError$attributes4 = _castError$attributes3.error) === null || _castError$attributes4 === void 0 ? void 0 : (_castError$attributes5 = _castError$attributes4.caused_by) === null || _castError$attributes5 === void 0 ? void 0 : _castError$attributes5.type) === 'index_not_found_exception';
};
exports.isIndexNotFoundError = isIndexNotFoundError;
const isAbortError = error => {
  return (error === null || error === void 0 ? void 0 : error.name) === 'AbortError';
};
exports.isAbortError = isAbortError;