"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAnomaliesDefaultTableColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _entity = require("../entity");
var _create_compound_key = require("./create_compound_key");
var i18n = _interopRequireWildcard(require("./translations"));
var _get_entries = require("../get_entries");
var _score = require("../score/score");
var _create_explorer_link = require("../links/create_explorer_link");
var _formatted_date = require("../../formatted_date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/tables/get_anomalies_table_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getAnomaliesDefaultTableColumns = (startDate, endDate) => [{
  name: i18n.DETECTOR,
  field: 'jobName',
  sortable: true,
  render: (jobName, anomalyBy) => /*#__PURE__*/_react.default.createElement(_create_explorer_link.ExplorerLink, {
    score: anomalyBy.anomaly,
    startDate: startDate,
    endDate: endDate,
    linkName: jobName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  })
}, {
  name: i18n.SCORE,
  field: 'anomaly.severity',
  sortable: true,
  render: (_, anomalyBy) => /*#__PURE__*/_react.default.createElement(_score.Score, {
    score: anomalyBy.anomaly,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 31
    }
  })
}, {
  name: i18n.ENTITY,
  field: 'anomaly.entityValue',
  sortable: true,
  render: (entityValue, anomalyBy) => /*#__PURE__*/_react.default.createElement(_entity.Entity, {
    entityName: anomalyBy.anomaly.entityName,
    entityValue: entityValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  })
}, {
  name: i18n.INFLUENCED_BY,
  field: 'anomaly.influencers',
  render: (influencers, anomalyBy) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, influencers && influencers.map(influencer => {
    const [key, value] = (0, _get_entries.getEntries)(influencer);
    const entityName = key != null ? key : '';
    const entityValue = value != null ? value : '';
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: `${entityName}-${entityValue}-${(0, _create_compound_key.createCompoundAnomalyKey)(anomalyBy.anomaly)}`,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_entity.Entity, {
      entityName: entityName,
      entityValue: entityValue,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 21
      }
    }))));
  }))
}, {
  name: i18n.TIME_STAMP,
  field: 'anomaly.time',
  sortable: true,
  render: time => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
    value: time,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 23
    }
  })
}];
exports.getAnomaliesDefaultTableColumns = getAnomaliesDefaultTableColumns;