"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostUnisolation = void 0;
var _react = require("react");
var _use_app_toasts = require("../../../../hooks/use_app_toasts");
var _translations = require("../../../../../detections/containers/detection_engine/alerts/translations");
var _api = require("../../../../../detections/containers/detection_engine/alerts/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostUnisolation = ({
  endpointId,
  comment,
  caseIds,
  agentType
}) => {
  const [loading, setLoading] = (0, _react.useState)(false);
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const unIsolateHost = (0, _react.useCallback)(async () => {
    try {
      setLoading(true);
      const isolationStatus = await (0, _api.createHostUnIsolation)({
        endpointId,
        comment,
        caseIds: caseIds && caseIds.length > 0 ? caseIds : undefined,
        agentType
      });
      setLoading(false);
      return isolationStatus.action ? true : false;
    } catch (error) {
      setLoading(false);
      addError(error, {
        title: _translations.HOST_ISOLATION_FAILURE
      });
      return false;
    }
  }, [endpointId, comment, caseIds, agentType, addError]);
  return {
    loading,
    unIsolateHost
  };
};
exports.useHostUnisolation = useHostUnisolation;