"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetEvents = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("@kbn/kibana-utils-plugin/common");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../common/lib/kibana");
var _search_events = require("./search_events");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetEvents = (dataView, parameters) => {
  const toasts = (0, _kibana.useToasts)();
  return (0, _reactQuery.useQuery)([dataView.getIndexPattern(), parameters.eventIds, parameters.sort, parameters.pageIndex, parameters.itemsPerPage], ({
    signal
  }) => (0, _search_events.searchEvents)(signal, dataView, parameters), {
    onError: error => {
      if (error instanceof _common.AbortError) {
        return;
      }
      toasts.addError(error, {
        title: i18n.EVENTS_ERROR_TITLE
      });
    }
  });
};
exports.useGetEvents = useGetEvents;