"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedActions = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _separator = require("../separator");
var _take_action = require("../../take_action");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/summary/selected_actions/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SelectedActionsComponent = ({
  refetchFindAttackDiscoveries,
  selectedAttackDiscoveries,
  selectedConnectorAttackDiscoveries,
  setSelectedAttackDiscoveries
}) => {
  const selectedCount = (0, _react.useMemo)(() => Object.values(selectedAttackDiscoveries).filter(Boolean).length, [selectedAttackDiscoveries]);
  const selected = (0, _react.useMemo)(() => {
    const selectedIds = Object.keys(selectedAttackDiscoveries).filter(id => selectedAttackDiscoveries[id]);
    return selectedConnectorAttackDiscoveries.filter(discovery => selectedIds.includes(discovery.id));
  }, [selectedAttackDiscoveries, selectedConnectorAttackDiscoveries]);
  const buttonText = (0, _react.useMemo)(() => i18n.SELECTED_DISCOVERIES(selectedCount), [selectedCount]);
  if (selectedCount === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "summary",
    gutterSize: "none",
    responsive: false,
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_separator.Separator, {
    marginRight: "0px",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_take_action.TakeAction, {
    attackDiscoveries: selected,
    buttonSize: "xs",
    buttonText: buttonText,
    refetchFindAttackDiscoveries: refetchFindAttackDiscoveries,
    setSelectedAttackDiscoveries: setSelectedAttackDiscoveries,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  })));
};
const SelectedActions = exports.SelectedActions = /*#__PURE__*/_react.default.memo(SelectedActionsComponent);