"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createFilterInDiscoverCellActionFactory = void 0;
var _is_in_security_app = require("../../../../common/hooks/is_in_security_app");
var _filter_in = require("../cell_action/filter_in");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createFilterInDiscoverCellActionFactory = ({
  store,
  services
}) => {
  const {
    application
  } = services;
  let currentAppId;
  application.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  const securityFilterInActionFactory = (0, _filter_in.createFilterInCellActionFactory)({
    store,
    services
  });
  return securityFilterInActionFactory.combine({
    isCompatible: async () => (0, _is_in_security_app.isInSecurityApp)(currentAppId)
  });
};
exports.createFilterInDiscoverCellActionFactory = createFilterInDiscoverCellActionFactory;