"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAddToTimelineDiscoverCellActionFactory = void 0;
var _is_in_security_app = require("../../../../common/hooks/is_in_security_app");
var _timeline_capabilities = require("../../../../common/utils/timeline_capabilities");
var _add_to_timeline = require("../cell_action/add_to_timeline");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAddToTimelineDiscoverCellActionFactory = ({
  store,
  services
}) => {
  const {
    application
  } = services;
  const timelineCapabilities = (0, _timeline_capabilities.extractTimelineCapabilities)(application.capabilities);
  let currentAppId;
  application.currentAppId$.subscribe(appId => {
    currentAppId = appId;
  });
  const securityAddToTimelineActionFactory = (0, _add_to_timeline.createAddToTimelineCellActionFactory)({
    store,
    services
  });
  return securityAddToTimelineActionFactory.combine({
    isCompatible: async () => timelineCapabilities.read && (0, _is_in_security_app.isInSecurityApp)(currentAppId)
  });
};
exports.createAddToTimelineDiscoverCellActionFactory = createAddToTimelineDiscoverCellActionFactory;