"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPrivilegedMonitorUsersIndex = exports.getPrivilegeUserMonitoringRequiredEsIndexPrivileges = exports.defaultMonitoringUsersIndex = void 0;
var _constants = require("../constants");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Default index for privileged monitoring users.
const defaultMonitoringUsersIndex = namespace => `entity_analytics.privileged_monitoring.${namespace}`;
exports.defaultMonitoringUsersIndex = defaultMonitoringUsersIndex;
const getPrivilegedMonitorUsersIndex = namespace => `${_constants.PRIVMON_BASE_INDEX_NAME}.users-${namespace}`;

// At the moment, this only includes the privileges required for reading dashboards.
exports.getPrivilegedMonitorUsersIndex = getPrivilegedMonitorUsersIndex;
const getPrivilegeUserMonitoringRequiredEsIndexPrivileges = namespace => ({
  [getPrivilegedMonitorUsersIndex(namespace)]: ['read'],
  [_constants.RISK_SCORE_INDEX_PATTERN]: ['read'],
  [(0, _utils.getAlertsIndex)(namespace)]: ['read'],
  [_constants.ML_ANOMALIES_INDEX]: ['read']
});
exports.getPrivilegeUserMonitoringRequiredEsIndexPrivileges = getPrivilegeUserMonitoringRequiredEsIndexPrivileges;