"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ENDPOINT_EVENTS_LOG_INDEX_FIELDS = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * A list of ECS fields that can appear on the `logs-endpoint.events.*` index.
 * Used to defined Event Filters and Endpoint Exceptions
 */
const ENDPOINT_EVENTS_LOG_INDEX_FIELDS = exports.ENDPOINT_EVENTS_LOG_INDEX_FIELDS = ['@timestamp', 'Effective_process.entity_id', 'Effective_process.executable', 'Effective_process.name', 'Effective_process.pid', 'Persistence.args', 'Persistence.executable', 'Persistence.keepalive', 'Persistence.name', 'Persistence.path', 'Persistence.runatload', 'Target.process.Ext.memory_region.allocation_base', 'Target.process.Ext.memory_region.allocation_protection', 'Target.process.Ext.memory_region.allocation_size', 'Target.process.Ext.memory_region.allocation_type', 'Target.process.Ext.memory_region.bytes_address', 'Target.process.Ext.memory_region.bytes_allocation_offset', 'Target.process.Ext.memory_region.bytes_compressed', 'Target.process.Ext.memory_region.bytes_compressed_present', 'Target.process.Ext.memory_region.hash.sha256', 'Target.process.Ext.memory_region.malware_signature.all_names', 'Target.process.Ext.memory_region.malware_signature.identifier', 'Target.process.Ext.memory_region.malware_signature.primary.matches', 'Target.process.Ext.memory_region.malware_signature.primary.signature.hash.sha256', 'Target.process.Ext.memory_region.malware_signature.primary.signature.id', 'Target.process.Ext.memory_region.malware_signature.primary.signature.name', 'Target.process.Ext.memory_region.malware_signature.version', 'Target.process.Ext.memory_region.mapped_path', 'Target.process.Ext.memory_region.mapped_pe.Ext.dotnet', 'Target.process.Ext.memory_region.mapped_pe.Ext.sections.hash.md5', 'Target.process.Ext.memory_region.mapped_pe.Ext.sections.hash.sha1', 'Target.process.Ext.memory_region.mapped_pe.Ext.sections.hash.sha256', 'Target.process.Ext.memory_region.mapped_pe.Ext.sections.hash.sha384', 'Target.process.Ext.memory_region.mapped_pe.Ext.sections.hash.sha512', 'Target.process.Ext.memory_region.mapped_pe.Ext.sections.hash.ssdeep', 'Target.process.Ext.memory_region.mapped_pe.Ext.sections.hash.tlsh', 'Target.process.Ext.memory_region.mapped_pe.Ext.sections.name', 'Target.process.Ext.memory_region.mapped_pe.Ext.streams.hash.md5', 'Target.process.Ext.memory_region.mapped_pe.Ext.streams.hash.sha1', 'Target.process.Ext.memory_region.mapped_pe.Ext.streams.hash.sha256', 'Target.process.Ext.memory_region.mapped_pe.Ext.streams.hash.sha384', 'Target.process.Ext.memory_region.mapped_pe.Ext.streams.hash.sha512', 'Target.process.Ext.memory_region.mapped_pe.Ext.streams.hash.ssdeep', 'Target.process.Ext.memory_region.mapped_pe.Ext.streams.hash.tlsh', 'Target.process.Ext.memory_region.mapped_pe.Ext.streams.name', 'Target.process.Ext.memory_region.mapped_pe.architecture', 'Target.process.Ext.memory_region.mapped_pe.company', 'Target.process.Ext.memory_region.mapped_pe.description', 'Target.process.Ext.memory_region.mapped_pe.file_version', 'Target.process.Ext.memory_region.mapped_pe.go_import_hash', 'Target.process.Ext.memory_region.mapped_pe.go_imports', 'Target.process.Ext.memory_region.mapped_pe.go_imports_names_entropy', 'Target.process.Ext.memory_region.mapped_pe.go_imports_names_var_entropy', 'Target.process.Ext.memory_region.mapped_pe.go_stripped', 'Target.process.Ext.memory_region.mapped_pe.imphash', 'Target.process.Ext.memory_region.mapped_pe.import_hash', 'Target.process.Ext.memory_region.mapped_pe.imports', 'Target.process.Ext.memory_region.mapped_pe.imports_names_entropy', 'Target.process.Ext.memory_region.mapped_pe.imports_names_var_entropy', 'Target.process.Ext.memory_region.mapped_pe.original_file_name', 'Target.process.Ext.memory_region.mapped_pe.pehash', 'Target.process.Ext.memory_region.mapped_pe.product', 'Target.process.Ext.memory_region.mapped_pe.sections.entropy', 'Target.process.Ext.memory_region.mapped_pe.sections.name', 'Target.process.Ext.memory_region.mapped_pe.sections.physical_size', 'Target.process.Ext.memory_region.mapped_pe.sections.var_entropy', 'Target.process.Ext.memory_region.mapped_pe.sections.virtual_size', 'Target.process.Ext.memory_region.mapped_pe_detected', 'Target.process.Ext.memory_region.memory_pe.Ext.dotnet', 'Target.process.Ext.memory_region.memory_pe.Ext.sections.hash.md5', 'Target.process.Ext.memory_region.memory_pe.Ext.sections.hash.sha1', 'Target.process.Ext.memory_region.memory_pe.Ext.sections.hash.sha256', 'Target.process.Ext.memory_region.memory_pe.Ext.sections.hash.sha384', 'Target.process.Ext.memory_region.memory_pe.Ext.sections.hash.sha512', 'Target.process.Ext.memory_region.memory_pe.Ext.sections.hash.ssdeep', 'Target.process.Ext.memory_region.memory_pe.Ext.sections.hash.tlsh', 'Target.process.Ext.memory_region.memory_pe.Ext.sections.name', 'Target.process.Ext.memory_region.memory_pe.Ext.streams.hash.md5', 'Target.process.Ext.memory_region.memory_pe.Ext.streams.hash.sha1', 'Target.process.Ext.memory_region.memory_pe.Ext.streams.hash.sha256', 'Target.process.Ext.memory_region.memory_pe.Ext.streams.hash.sha384', 'Target.process.Ext.memory_region.memory_pe.Ext.streams.hash.sha512', 'Target.process.Ext.memory_region.memory_pe.Ext.streams.hash.ssdeep', 'Target.process.Ext.memory_region.memory_pe.Ext.streams.hash.tlsh', 'Target.process.Ext.memory_region.memory_pe.Ext.streams.name', 'Target.process.Ext.memory_region.memory_pe.architecture', 'Target.process.Ext.memory_region.memory_pe.company', 'Target.process.Ext.memory_region.memory_pe.description', 'Target.process.Ext.memory_region.memory_pe.file_version', 'Target.process.Ext.memory_region.memory_pe.go_import_hash', 'Target.process.Ext.memory_region.memory_pe.go_imports', 'Target.process.Ext.memory_region.memory_pe.go_imports_names_entropy', 'Target.process.Ext.memory_region.memory_pe.go_imports_names_var_entropy', 'Target.process.Ext.memory_region.memory_pe.go_stripped', 'Target.process.Ext.memory_region.memory_pe.imphash', 'Target.process.Ext.memory_region.memory_pe.import_hash', 'Target.process.Ext.memory_region.memory_pe.imports', 'Target.process.Ext.memory_region.memory_pe.imports_names_entropy', 'Target.process.Ext.memory_region.memory_pe.imports_names_var_entropy', 'Target.process.Ext.memory_region.memory_pe.original_file_name', 'Target.process.Ext.memory_region.memory_pe.pehash', 'Target.process.Ext.memory_region.memory_pe.product', 'Target.process.Ext.memory_region.memory_pe.sections.entropy', 'Target.process.Ext.memory_region.memory_pe.sections.name', 'Target.process.Ext.memory_region.memory_pe.sections.physical_size', 'Target.process.Ext.memory_region.memory_pe.sections.var_entropy', 'Target.process.Ext.memory_region.memory_pe.sections.virtual_size', 'Target.process.Ext.memory_region.memory_pe_detected', 'Target.process.Ext.memory_region.region_base', 'Target.process.Ext.memory_region.region_protection', 'Target.process.Ext.memory_region.region_size', 'Target.process.Ext.memory_region.region_state', 'Target.process.Ext.memory_region.strings', 'Target.process.Ext.token.integrity_level_name', 'Target.process.entity_id', 'Target.process.executable', 'Target.process.executable.caseless', 'Target.process.executable.text', 'Target.process.name', 'Target.process.name.caseless', 'Target.process.name.text', 'Target.process.pid', '_id', '_index', '_score', '_source', 'agent.ephemeral_id', 'agent.id', 'agent.name', 'agent.type', 'agent.version', 'cloud.account.id', 'cloud.instance.name', 'cloud.project.id', 'cloud.provider', 'cloud.region', 'container.id', 'container.image.hash.all', 'container.image.name', 'container.image.tag', 'container.name', 'data_stream.dataset', 'data_stream.namespace', 'data_stream.type', 'destination.address', 'destination.as.number', 'destination.as.organization.name', 'destination.as.organization.name.text', 'destination.bytes', 'destination.domain', 'destination.geo.city_name', 'destination.geo.continent_code', 'destination.geo.continent_name', 'destination.geo.country_iso_code', 'destination.geo.country_name', 'destination.geo.location', 'destination.geo.name', 'destination.geo.postal_code', 'destination.geo.region_iso_code', 'destination.geo.region_name', 'destination.geo.timezone', 'destination.ip', 'destination.packets', 'destination.port', 'destination.registered_domain', 'destination.top_level_domain', 'dll.Ext.code_signature.exists', 'dll.Ext.code_signature.status', 'dll.Ext.code_signature.subject_name', 'dll.Ext.code_signature.trusted', 'dll.Ext.code_signature.valid', 'dll.Ext.defense_evasions', 'dll.Ext.device.bus_type', 'dll.Ext.device.dos_name', 'dll.Ext.device.file_system_type', 'dll.Ext.device.nt_name', 'dll.Ext.device.product_id', 'dll.Ext.device.serial_number', 'dll.Ext.device.vendor_id', 'dll.Ext.device.volume_device_type', 'dll.Ext.load_index', 'dll.Ext.relative_file_creation_time', 'dll.Ext.relative_file_name_modify_time', 'dll.Ext.size', 'dll.code_signature.exists', 'dll.code_signature.signing_id', 'dll.code_signature.status', 'dll.code_signature.subject_name', 'dll.code_signature.team_id', 'dll.code_signature.trusted', 'dll.code_signature.valid', 'dll.hash.md5', 'dll.hash.sha1', 'dll.hash.sha256', 'dll.hash.sha512', 'dll.name', 'dll.path', 'dll.pe.company', 'dll.pe.description', 'dll.pe.file_version', 'dll.pe.imphash', 'dll.pe.original_file_name', 'dll.pe.product', 'dns.Ext.options', 'dns.Ext.status', 'dns.question.name', 'dns.question.registered_domain', 'dns.question.subdomain', 'dns.question.top_level_domain', 'dns.question.type', 'dns.resolved_ip', 'ecs.version', 'event.Ext.correlation.id', 'event.action', 'event.agent_id_status', 'event.category', 'event.code', 'event.created', 'event.dataset', 'event.end', 'event.hash', 'event.id', 'event.ingested', 'event.kind', 'event.module', 'event.outcome', 'event.provider', 'event.sequence', 'event.severity', 'event.start', 'event.type', 'file.Ext.code_signature.exists', 'file.Ext.code_signature.status', 'file.Ext.code_signature.subject_name', 'file.Ext.code_signature.trusted', 'file.Ext.code_signature.valid', 'file.Ext.device.bus_type', 'file.Ext.device.dos_name', 'file.Ext.device.file_system_type', 'file.Ext.device.nt_name', 'file.Ext.device.product_id', 'file.Ext.device.serial_number', 'file.Ext.device.vendor_id', 'file.Ext.device.volume_device_type', 'file.Ext.entropy', 'file.Ext.header_bytes', 'file.Ext.header_data', 'file.Ext.malware_signature.all_names', 'file.Ext.malware_signature.identifier', 'file.Ext.malware_signature.primary.signature.hash.sha256', 'file.Ext.malware_signature.primary.signature.id', 'file.Ext.malware_signature.primary.signature.name', 'file.Ext.malware_signature.version', 'file.Ext.monotonic_id', 'file.Ext.original.extension', 'file.Ext.original.gid', 'file.Ext.original.group', 'file.Ext.original.mode', 'file.Ext.original.name', 'file.Ext.original.owner', 'file.Ext.original.path', 'file.Ext.original.uid', 'file.Ext.windows.zone_identifier', 'file.accessed', 'file.attributes', 'file.code_signature.exists', 'file.code_signature.signing_id', 'file.code_signature.status', 'file.code_signature.subject_name', 'file.code_signature.team_id', 'file.code_signature.trusted', 'file.code_signature.valid', 'file.created', 'file.ctime', 'file.device', 'file.directory', 'file.drive_letter', 'file.extension', 'file.gid', 'file.group', 'file.hash.md5', 'file.hash.sha1', 'file.hash.sha256', 'file.hash.sha512', 'file.inode', 'file.mime_type', 'file.mode', 'file.mtime', 'file.name', 'file.owner', 'file.path', 'file.path.caseless', 'file.path.text', 'file.pe.company', 'file.pe.description', 'file.pe.file_version', 'file.pe.imphash', 'file.pe.original_file_name', 'file.pe.product', 'file.size', 'file.target_path', 'file.target_path.caseless', 'file.target_path.text', 'file.type', 'file.uid', 'group.Ext.real.id', 'group.Ext.real.name', 'group.domain', 'group.id', 'group.name', 'host.architecture', 'host.boot.id', 'host.domain', 'host.hostname', 'host.id', 'host.ip', 'host.mac', 'host.name', 'host.os.Ext.variant', 'host.os.family', 'host.os.full', 'host.os.full.caseless', 'host.os.full.text', 'host.os.kernel', 'host.os.name', 'host.os.name.caseless', 'host.os.name.text', 'host.os.platform', 'host.os.type', 'host.os.version', 'host.pid_ns_ino', 'host.type', 'host.uptime', 'http.request.body.bytes', 'http.request.body.content', 'http.request.body.content.text', 'http.request.bytes', 'http.response.Ext.version', 'http.response.body.bytes', 'http.response.body.content', 'http.response.body.content.text', 'http.response.bytes', 'http.response.status_code', 'message', 'network.bytes', 'network.community_id', 'network.direction', 'network.iana_number', 'network.packets', 'network.protocol', 'network.transport', 'network.type', 'orchestrator.cluster.id', 'orchestrator.cluster.name', 'orchestrator.namespace', 'orchestrator.resource.ip', 'orchestrator.resource.name', 'orchestrator.resource.parent.type', 'orchestrator.resource.type', 'package.name', 'process.Ext.ancestry', 'process.Ext.api.behaviors', 'process.Ext.api.metadata.background_callcount', 'process.Ext.api.metadata.ms_since_last_keyevent', 'process.Ext.api.metadata.procedure_symbol', 'process.Ext.api.metadata.return_value', 'process.Ext.api.metadata.start_address_allocation_protection', 'process.Ext.api.metadata.start_address_module', 'process.Ext.api.metadata.target_address_name', 'process.Ext.api.metadata.target_address_path', 'process.Ext.api.metadata.thread_info_flags', 'process.Ext.api.metadata.visible_windows_count', 'process.Ext.api.metadata.windows_count', 'process.Ext.api.name', 'process.Ext.api.parameters.address', 'process.Ext.api.parameters.allocation_type', 'process.Ext.api.parameters.argument1', 'process.Ext.api.parameters.argument2', 'process.Ext.api.parameters.argument3', 'process.Ext.api.parameters.context_flags', 'process.Ext.api.parameters.desired_access', 'process.Ext.api.parameters.desired_access_numeric', 'process.Ext.api.parameters.device', 'process.Ext.api.parameters.driver', 'process.Ext.api.parameters.eax', 'process.Ext.api.parameters.ebp', 'process.Ext.api.parameters.ebx', 'process.Ext.api.parameters.ecx', 'process.Ext.api.parameters.edi', 'process.Ext.api.parameters.edx', 'process.Ext.api.parameters.eip', 'process.Ext.api.parameters.esi', 'process.Ext.api.parameters.esp', 'process.Ext.api.parameters.flags', 'process.Ext.api.parameters.handle_type', 'process.Ext.api.parameters.hook_module', 'process.Ext.api.parameters.hook_type', 'process.Ext.api.parameters.procedure', 'process.Ext.api.parameters.protection', 'process.Ext.api.parameters.protection_old', 'process.Ext.api.parameters.r8', 'process.Ext.api.parameters.r9', 'process.Ext.api.parameters.rax', 'process.Ext.api.parameters.rbp', 'process.Ext.api.parameters.rbx', 'process.Ext.api.parameters.rcx', 'process.Ext.api.parameters.rdi', 'process.Ext.api.parameters.rdx', 'process.Ext.api.parameters.rip', 'process.Ext.api.parameters.rsi', 'process.Ext.api.parameters.rsp', 'process.Ext.api.parameters.size', 'process.Ext.api.parameters.usage', 'process.Ext.api.parameters.usage_page', 'process.Ext.api.summary', 'process.Ext.architecture', 'process.Ext.authentication_id', 'process.Ext.code_signature.exists', 'process.Ext.code_signature.status', 'process.Ext.code_signature.subject_name', 'process.Ext.code_signature.trusted', 'process.Ext.code_signature.valid', 'process.Ext.defense_evasions', 'process.Ext.device.bus_type', 'process.Ext.device.dos_name', 'process.Ext.device.file_system_type', 'process.Ext.device.nt_name', 'process.Ext.device.product_id', 'process.Ext.device.serial_number', 'process.Ext.device.vendor_id', 'process.Ext.device.volume_device_type', 'process.Ext.dll.Ext.mapped_address', 'process.Ext.dll.Ext.mapped_size', 'process.Ext.dll.name', 'process.Ext.dll.path', 'process.Ext.effective_parent.entity_id', 'process.Ext.effective_parent.executable', 'process.Ext.effective_parent.name', 'process.Ext.effective_parent.pid', 'process.Ext.memory_region.allocation_base', 'process.Ext.memory_region.allocation_protection', 'process.Ext.memory_region.allocation_size', 'process.Ext.memory_region.allocation_type', 'process.Ext.memory_region.bytes_address', 'process.Ext.memory_region.bytes_allocation_offset', 'process.Ext.memory_region.bytes_compressed', 'process.Ext.memory_region.bytes_compressed_present', 'process.Ext.memory_region.hash.sha256', 'process.Ext.memory_region.malware_signature.all_names', 'process.Ext.memory_region.malware_signature.identifier', 'process.Ext.memory_region.malware_signature.primary.matches', 'process.Ext.memory_region.malware_signature.primary.signature.hash.sha256', 'process.Ext.memory_region.malware_signature.primary.signature.id', 'process.Ext.memory_region.malware_signature.primary.signature.name', 'process.Ext.memory_region.malware_signature.version', 'process.Ext.memory_region.mapped_path', 'process.Ext.memory_region.mapped_pe.Ext.dotnet', 'process.Ext.memory_region.mapped_pe.Ext.sections.hash.md5', 'process.Ext.memory_region.mapped_pe.Ext.sections.hash.sha1', 'process.Ext.memory_region.mapped_pe.Ext.sections.hash.sha256', 'process.Ext.memory_region.mapped_pe.Ext.sections.hash.sha384', 'process.Ext.memory_region.mapped_pe.Ext.sections.hash.sha512', 'process.Ext.memory_region.mapped_pe.Ext.sections.hash.ssdeep', 'process.Ext.memory_region.mapped_pe.Ext.sections.hash.tlsh', 'process.Ext.memory_region.mapped_pe.Ext.sections.name', 'process.Ext.memory_region.mapped_pe.Ext.streams.hash.md5', 'process.Ext.memory_region.mapped_pe.Ext.streams.hash.sha1', 'process.Ext.memory_region.mapped_pe.Ext.streams.hash.sha256', 'process.Ext.memory_region.mapped_pe.Ext.streams.hash.sha384', 'process.Ext.memory_region.mapped_pe.Ext.streams.hash.sha512', 'process.Ext.memory_region.mapped_pe.Ext.streams.hash.ssdeep', 'process.Ext.memory_region.mapped_pe.Ext.streams.hash.tlsh', 'process.Ext.memory_region.mapped_pe.Ext.streams.name', 'process.Ext.memory_region.mapped_pe.architecture', 'process.Ext.memory_region.mapped_pe.company', 'process.Ext.memory_region.mapped_pe.description', 'process.Ext.memory_region.mapped_pe.file_version', 'process.Ext.memory_region.mapped_pe.go_import_hash', 'process.Ext.memory_region.mapped_pe.go_imports', 'process.Ext.memory_region.mapped_pe.go_imports_names_entropy', 'process.Ext.memory_region.mapped_pe.go_imports_names_var_entropy', 'process.Ext.memory_region.mapped_pe.go_stripped', 'process.Ext.memory_region.mapped_pe.imphash', 'process.Ext.memory_region.mapped_pe.import_hash', 'process.Ext.memory_region.mapped_pe.imports', 'process.Ext.memory_region.mapped_pe.imports_names_entropy', 'process.Ext.memory_region.mapped_pe.imports_names_var_entropy', 'process.Ext.memory_region.mapped_pe.original_file_name', 'process.Ext.memory_region.mapped_pe.pehash', 'process.Ext.memory_region.mapped_pe.product', 'process.Ext.memory_region.mapped_pe.sections.entropy', 'process.Ext.memory_region.mapped_pe.sections.name', 'process.Ext.memory_region.mapped_pe.sections.physical_size', 'process.Ext.memory_region.mapped_pe.sections.var_entropy', 'process.Ext.memory_region.mapped_pe.sections.virtual_size', 'process.Ext.memory_region.mapped_pe_detected', 'process.Ext.memory_region.memory_pe.Ext.dotnet', 'process.Ext.memory_region.memory_pe.Ext.sections.hash.md5', 'process.Ext.memory_region.memory_pe.Ext.sections.hash.sha1', 'process.Ext.memory_region.memory_pe.Ext.sections.hash.sha256', 'process.Ext.memory_region.memory_pe.Ext.sections.hash.sha384', 'process.Ext.memory_region.memory_pe.Ext.sections.hash.sha512', 'process.Ext.memory_region.memory_pe.Ext.sections.hash.ssdeep', 'process.Ext.memory_region.memory_pe.Ext.sections.hash.tlsh', 'process.Ext.memory_region.memory_pe.Ext.sections.name', 'process.Ext.memory_region.memory_pe.Ext.streams.hash.md5', 'process.Ext.memory_region.memory_pe.Ext.streams.hash.sha1', 'process.Ext.memory_region.memory_pe.Ext.streams.hash.sha256', 'process.Ext.memory_region.memory_pe.Ext.streams.hash.sha384', 'process.Ext.memory_region.memory_pe.Ext.streams.hash.sha512', 'process.Ext.memory_region.memory_pe.Ext.streams.hash.ssdeep', 'process.Ext.memory_region.memory_pe.Ext.streams.hash.tlsh', 'process.Ext.memory_region.memory_pe.Ext.streams.name', 'process.Ext.memory_region.memory_pe.architecture', 'process.Ext.memory_region.memory_pe.company', 'process.Ext.memory_region.memory_pe.description', 'process.Ext.memory_region.memory_pe.file_version', 'process.Ext.memory_region.memory_pe.go_import_hash', 'process.Ext.memory_region.memory_pe.go_imports', 'process.Ext.memory_region.memory_pe.go_imports_names_entropy', 'process.Ext.memory_region.memory_pe.go_imports_names_var_entropy', 'process.Ext.memory_region.memory_pe.go_stripped', 'process.Ext.memory_region.memory_pe.imphash', 'process.Ext.memory_region.memory_pe.import_hash', 'process.Ext.memory_region.memory_pe.imports', 'process.Ext.memory_region.memory_pe.imports_names_entropy', 'process.Ext.memory_region.memory_pe.imports_names_var_entropy', 'process.Ext.memory_region.memory_pe.original_file_name', 'process.Ext.memory_region.memory_pe.pehash', 'process.Ext.memory_region.memory_pe.product', 'process.Ext.memory_region.memory_pe.sections.entropy', 'process.Ext.memory_region.memory_pe.sections.name', 'process.Ext.memory_region.memory_pe.sections.physical_size', 'process.Ext.memory_region.memory_pe.sections.var_entropy', 'process.Ext.memory_region.memory_pe.sections.virtual_size', 'process.Ext.memory_region.memory_pe_detected', 'process.Ext.memory_region.region_base', 'process.Ext.memory_region.region_protection', 'process.Ext.memory_region.region_size', 'process.Ext.memory_region.region_state', 'process.Ext.memory_region.strings', 'process.Ext.mitigation_policies', 'process.Ext.protection', 'process.Ext.relative_file_creation_time', 'process.Ext.relative_file_name_modify_time', 'process.Ext.session', 'process.Ext.session_info.authentication_package', 'process.Ext.session_info.client_address', 'process.Ext.session_info.id', 'process.Ext.session_info.logon_type', 'process.Ext.session_info.relative_logon_time', 'process.Ext.session_info.relative_password_age', 'process.Ext.session_info.user_flags', 'process.Ext.token.elevation', 'process.Ext.token.elevation_level', 'process.Ext.token.elevation_type', 'process.Ext.token.integrity_level_name', 'process.Ext.token.security_attributes', 'process.Ext.trusted', 'process.Ext.trusted_descendant', 'process.args', 'process.args_count', 'process.code_signature.exists', 'process.code_signature.signing_id', 'process.code_signature.status', 'process.code_signature.subject_name', 'process.code_signature.team_id', 'process.code_signature.trusted', 'process.code_signature.valid', 'process.command_line', 'process.command_line.caseless', 'process.command_line.text', 'process.end', 'process.entity_id', 'process.entry_leader.args', 'process.entry_leader.args_count', 'process.entry_leader.attested_groups.name', 'process.entry_leader.attested_user.id', 'process.entry_leader.attested_user.name', 'process.entry_leader.attested_user.name.text', 'process.entry_leader.command_line', 'process.entry_leader.command_line.caseless', 'process.entry_leader.command_line.text', 'process.entry_leader.entity_id', 'process.entry_leader.entry_meta.source.ip', 'process.entry_leader.entry_meta.type', 'process.entry_leader.executable', 'process.entry_leader.executable.caseless', 'process.entry_leader.executable.text', 'process.entry_leader.group.id', 'process.entry_leader.group.name', 'process.entry_leader.interactive', 'process.entry_leader.name', 'process.entry_leader.name.caseless', 'process.entry_leader.name.text', 'process.entry_leader.parent.entity_id', 'process.entry_leader.parent.pid', 'process.entry_leader.parent.session_leader.entity_id', 'process.entry_leader.parent.session_leader.pid', 'process.entry_leader.parent.session_leader.start', 'process.entry_leader.parent.start', 'process.entry_leader.pid', 'process.entry_leader.real_group.id', 'process.entry_leader.real_group.name', 'process.entry_leader.real_user.id', 'process.entry_leader.real_user.name', 'process.entry_leader.real_user.name.text', 'process.entry_leader.same_as_process', 'process.entry_leader.saved_group.id', 'process.entry_leader.saved_group.name', 'process.entry_leader.saved_user.id', 'process.entry_leader.saved_user.name', 'process.entry_leader.saved_user.name.text', 'process.entry_leader.start', 'process.entry_leader.supplemental_groups.id', 'process.entry_leader.supplemental_groups.name', 'process.entry_leader.tty.char_device.major', 'process.entry_leader.tty.char_device.minor', 'process.entry_leader.user.id', 'process.entry_leader.user.name', 'process.entry_leader.user.name.text', 'process.entry_leader.working_directory', 'process.entry_leader.working_directory.caseless', 'process.entry_leader.working_directory.text', 'process.env_vars', 'process.executable', 'process.executable.caseless', 'process.executable.text', 'process.exit_code', 'process.group.id', 'process.group.name', 'process.group_leader.args', 'process.group_leader.args_count', 'process.group_leader.command_line', 'process.group_leader.command_line.caseless', 'process.group_leader.command_line.text', 'process.group_leader.entity_id', 'process.group_leader.executable', 'process.group_leader.executable.caseless', 'process.group_leader.executable.text', 'process.group_leader.group.id', 'process.group_leader.group.name', 'process.group_leader.interactive', 'process.group_leader.name', 'process.group_leader.name.caseless', 'process.group_leader.name.text', 'process.group_leader.pid', 'process.group_leader.real_group.id', 'process.group_leader.real_group.name', 'process.group_leader.real_user.id', 'process.group_leader.real_user.name', 'process.group_leader.real_user.name.text', 'process.group_leader.same_as_process', 'process.group_leader.saved_group.id', 'process.group_leader.saved_group.name', 'process.group_leader.saved_user.id', 'process.group_leader.saved_user.name', 'process.group_leader.saved_user.name.text', 'process.group_leader.start', 'process.group_leader.supplemental_groups.id', 'process.group_leader.supplemental_groups.name', 'process.group_leader.tty.char_device.major', 'process.group_leader.tty.char_device.minor', 'process.group_leader.user.id', 'process.group_leader.user.name', 'process.group_leader.user.name.text', 'process.group_leader.working_directory', 'process.group_leader.working_directory.caseless', 'process.group_leader.working_directory.text', 'process.hash.md5', 'process.hash.sha1', 'process.hash.sha256', 'process.hash.sha512', 'process.interactive', 'process.io.max_bytes_per_process_exceeded', 'process.io.text', 'process.io.total_bytes_captured', 'process.io.total_bytes_skipped', 'process.name', 'process.name.caseless', 'process.name.text', 'process.parent.Ext.architecture', 'process.parent.Ext.code_signature.exists', 'process.parent.Ext.code_signature.status', 'process.parent.Ext.code_signature.subject_name', 'process.parent.Ext.code_signature.trusted', 'process.parent.Ext.code_signature.valid', 'process.parent.Ext.protection', 'process.parent.Ext.real.pid', 'process.parent.Ext.user', 'process.parent.args', 'process.parent.args_count', 'process.parent.code_signature.exists', 'process.parent.code_signature.signing_id', 'process.parent.code_signature.status', 'process.parent.code_signature.subject_name', 'process.parent.code_signature.team_id', 'process.parent.code_signature.trusted', 'process.parent.code_signature.valid', 'process.parent.command_line', 'process.parent.command_line.caseless', 'process.parent.command_line.text', 'process.parent.entity_id', 'process.parent.executable', 'process.parent.executable.caseless', 'process.parent.executable.text', 'process.parent.exit_code', 'process.parent.group.id', 'process.parent.group.name', 'process.parent.group_leader.entity_id', 'process.parent.group_leader.pid', 'process.parent.group_leader.start', 'process.parent.hash.md5', 'process.parent.hash.sha1', 'process.parent.hash.sha256', 'process.parent.hash.sha512', 'process.parent.interactive', 'process.parent.name', 'process.parent.name.caseless', 'process.parent.name.text', 'process.parent.pe.company', 'process.parent.pe.description', 'process.parent.pe.file_version', 'process.parent.pe.imphash', 'process.parent.pe.original_file_name', 'process.parent.pe.product', 'process.parent.pgid', 'process.parent.pid', 'process.parent.ppid', 'process.parent.real_group.id', 'process.parent.real_group.name', 'process.parent.real_user.id', 'process.parent.real_user.name', 'process.parent.real_user.name.text', 'process.parent.saved_group.id', 'process.parent.saved_group.name', 'process.parent.saved_user.id', 'process.parent.saved_user.name', 'process.parent.saved_user.name.text', 'process.parent.start', 'process.parent.supplemental_groups.id', 'process.parent.supplemental_groups.name', 'process.parent.thread.Ext.call_stack.allocation_private_bytes', 'process.parent.thread.Ext.call_stack.callsite_leading_bytes', 'process.parent.thread.Ext.call_stack.callsite_trailing_bytes', 'process.parent.thread.Ext.call_stack.protection', 'process.parent.thread.Ext.call_stack.symbol_info', 'process.parent.thread.Ext.call_stack_contains_unbacked', 'process.parent.thread.Ext.call_stack_summary', 'process.parent.thread.id', 'process.parent.thread.name', 'process.parent.title', 'process.parent.title.text', 'process.parent.tty.char_device.major', 'process.parent.tty.char_device.minor', 'process.parent.uptime', 'process.parent.user.id', 'process.parent.user.name', 'process.parent.user.name.text', 'process.parent.working_directory', 'process.parent.working_directory.caseless', 'process.parent.working_directory.text', 'process.pe.company', 'process.pe.description', 'process.pe.file_version', 'process.pe.imphash', 'process.pe.original_file_name', 'process.pe.product', 'process.pgid', 'process.pid', 'process.ppid', 'process.previous.args', 'process.previous.args_count', 'process.previous.executable', 'process.previous.executable.caseless', 'process.previous.executable.text', 'process.real_group.id', 'process.real_group.name', 'process.real_user.id', 'process.real_user.name', 'process.real_user.name.text', 'process.saved_group.id', 'process.saved_group.name', 'process.saved_user.id', 'process.saved_user.name', 'process.saved_user.name.text', 'process.session_leader.args', 'process.session_leader.args_count', 'process.session_leader.command_line', 'process.session_leader.command_line.caseless', 'process.session_leader.command_line.text', 'process.session_leader.entity_id', 'process.session_leader.executable', 'process.session_leader.executable.caseless', 'process.session_leader.executable.text', 'process.session_leader.group.id', 'process.session_leader.group.name', 'process.session_leader.interactive', 'process.session_leader.name', 'process.session_leader.name.caseless', 'process.session_leader.name.text', 'process.session_leader.parent.entity_id', 'process.session_leader.parent.pid', 'process.session_leader.parent.session_leader.entity_id', 'process.session_leader.parent.session_leader.pid', 'process.session_leader.parent.session_leader.start', 'process.session_leader.parent.start', 'process.session_leader.pid', 'process.session_leader.real_group.id', 'process.session_leader.real_group.name', 'process.session_leader.real_user.id', 'process.session_leader.real_user.name', 'process.session_leader.real_user.name.text', 'process.session_leader.same_as_process', 'process.session_leader.saved_group.id', 'process.session_leader.saved_group.name', 'process.session_leader.saved_user.id', 'process.session_leader.saved_user.name', 'process.session_leader.saved_user.name.text', 'process.session_leader.start', 'process.session_leader.supplemental_groups.id', 'process.session_leader.supplemental_groups.name', 'process.session_leader.tty.char_device.major', 'process.session_leader.tty.char_device.minor', 'process.session_leader.user.id', 'process.session_leader.user.name', 'process.session_leader.user.name.text', 'process.session_leader.working_directory', 'process.session_leader.working_directory.caseless', 'process.session_leader.working_directory.text', 'process.start', 'process.supplemental_groups.id', 'process.supplemental_groups.name', 'process.thread.Ext.call_stack.allocation_private_bytes', 'process.thread.Ext.call_stack.callsite_leading_bytes', 'process.thread.Ext.call_stack.callsite_trailing_bytes', 'process.thread.Ext.call_stack.instruction_pointer', 'process.thread.Ext.call_stack.module_path', 'process.thread.Ext.call_stack.protection', 'process.thread.Ext.call_stack.protection_provenance', 'process.thread.Ext.call_stack.symbol_info', 'process.thread.Ext.call_stack_contains_unbacked', 'process.thread.Ext.call_stack_final_user_module.code_signature.exists', 'process.thread.Ext.call_stack_final_user_module.code_signature.status', 'process.thread.Ext.call_stack_final_user_module.code_signature.subject_name', 'process.thread.Ext.call_stack_final_user_module.code_signature.trusted', 'process.thread.Ext.call_stack_final_user_module.code_signature.valid', 'process.thread.Ext.call_stack_final_user_module.hash.sha256', 'process.thread.Ext.call_stack_final_user_module.name', 'process.thread.Ext.call_stack_final_user_module.path', 'process.thread.Ext.call_stack_final_user_module.protection_provenance', 'process.thread.Ext.call_stack_summary', 'process.thread.capabilities.effective', 'process.thread.capabilities.permitted', 'process.thread.id', 'process.thread.name', 'process.title', 'process.title.text', 'process.tty.char_device.major', 'process.tty.char_device.minor', 'process.tty.columns', 'process.tty.rows', 'process.uptime', 'process.user.id', 'process.user.name', 'process.user.name.text', 'process.working_directory', 'process.working_directory.caseless', 'process.working_directory.text', 'registry.data.bytes', 'registry.data.strings', 'registry.data.type', 'registry.hive', 'registry.key', 'registry.path', 'registry.value', 'source.address', 'source.as.number', 'source.as.organization.name', 'source.as.organization.name.text', 'source.bytes', 'source.domain', 'source.geo.city_name', 'source.geo.continent_code', 'source.geo.continent_name', 'source.geo.country_iso_code', 'source.geo.country_name', 'source.geo.location', 'source.geo.name', 'source.geo.postal_code', 'source.geo.region_iso_code', 'source.geo.region_name', 'source.geo.timezone', 'source.ip', 'source.packets', 'source.port', 'source.registered_domain', 'source.top_level_domain', 'user.Ext.real.id', 'user.Ext.real.name', 'user.domain', 'user.email', 'user.full_name', 'user.full_name.text', 'user.group.Ext.real.id', 'user.group.Ext.real.name', 'user.group.domain', 'user.group.id', 'user.group.name', 'user.hash', 'user.id', 'user.name', 'user.name.text'];