"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.userAuthenticationsSchema = exports.AuthStackByField = void 0;
var _zod = require("@kbn/zod");
var _factory_query_type = require("../model/factory_query_type");
var _request_paginated_options = require("../model/request_paginated_options");
var _timerange = require("../model/timerange");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AuthStackByField = exports.AuthStackByField = /*#__PURE__*/function (AuthStackByField) {
  AuthStackByField["userName"] = "user.name";
  AuthStackByField["hostName"] = "host.name";
  return AuthStackByField;
}({});
const userAuthenticationsSchema = exports.userAuthenticationsSchema = _request_paginated_options.requestOptionsPaginatedSchema.extend({
  stackByField: _zod.z.enum([AuthStackByField.userName, AuthStackByField.hostName]),
  timerange: _timerange.timerange,
  factoryQueryType: _zod.z.literal(_factory_query_type.UsersQueries.authentications)
});