"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KillProcessRouteResponse = exports.KillProcessRouteRequestBody = exports.EndpointKillProcessActionResponse = exports.EndpointKillProcessActionRequestBody = void 0;
var _zod = require("@kbn/zod");
var _common = require("../../../model/schema/common.gen");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * NOTICE: Do not edit this file manually.
 * This file is automatically generated by the OpenAPI Generator, @kbn/openapi-generator.
 *
 * info:
 *   title: Kill Process Schema
 *   version: 2023-10-31
 */

const KillProcessRouteRequestBody = exports.KillProcessRouteRequestBody = _common.BaseActionSchema.merge(_zod.z.object({
  parameters: _zod.z.union([_zod.z.object({
    /**
     * The process ID (PID) of the process to terminate.
     */
    pid: _zod.z.number().int().min(1).optional()
  }), _zod.z.object({
    /**
     * The entity ID of the process to terminate.
     */
    entity_id: _zod.z.string().min(1).optional()
  }), _zod.z.object({
    /**
     * The name of the process to terminate. Valid for SentinelOne agent type only.
     */
    process_name: _zod.z.string().min(1).optional()
  })])
}));
const KillProcessRouteResponse = exports.KillProcessRouteResponse = _zod.z.object({});
const EndpointKillProcessActionRequestBody = exports.EndpointKillProcessActionRequestBody = KillProcessRouteRequestBody;
const EndpointKillProcessActionResponse = exports.EndpointKillProcessActionResponse = KillProcessRouteResponse;