"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isTitleLinkCategory = exports.isSeparatorLinkCategory = exports.isAccordionLinkCategory = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Type guards

const isTitleLinkCategory = category => (category.type == null || category.type === _constants.LinkCategoryType.title) && category.label != null;
exports.isTitleLinkCategory = isTitleLinkCategory;
const isAccordionLinkCategory = category => category.type === _constants.LinkCategoryType.accordion && category.label != null;
exports.isAccordionLinkCategory = isAccordionLinkCategory;
const isSeparatorLinkCategory = category => category.type === _constants.LinkCategoryType.separator;
exports.isSeparatorLinkCategory = isSeparatorLinkCategory;