"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoveryBaseKibanaFeature = void 0;
var _coreApplicationCommon = require("@kbn/core-application-common");
var _i18n = require("@kbn/i18n");
var _constants = require("@kbn/elastic-assistant-common/constants");
var _constants2 = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const alertingFeatures = [{
  ruleTypeId: _constants.ATTACK_DISCOVERY_SCHEDULES_ALERT_TYPE_ID,
  consumers: [_constants2.SERVER_APP_ID]
}];
const getAttackDiscoveryBaseKibanaFeature = () => ({
  id: _constants2.ATTACK_DISCOVERY_FEATURE_ID,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.linkSecuritySolutionAttackDiscoveryTitle', {
    defaultMessage: 'Attack discovery'
  }),
  order: 1400,
  category: _coreApplicationCommon.DEFAULT_APP_CATEGORIES.security,
  app: [_constants2.ATTACK_DISCOVERY_FEATURE_ID, 'kibana'],
  catalogue: [_constants2.APP_ID],
  minimumLicense: 'enterprise',
  alerting: alertingFeatures,
  privileges: {
    all: {
      api: ['elasticAssistant'],
      // only required by legacy internal API routes authz
      app: [_constants2.ATTACK_DISCOVERY_FEATURE_ID, 'kibana'],
      catalogue: [_constants2.APP_ID],
      savedObject: {
        all: [],
        read: []
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      ui: []
    },
    read: {
      // No read-only mode currently supported
      disabled: true,
      savedObject: {
        all: [],
        read: []
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      },
      ui: []
    }
  }
});
exports.getAttackDiscoveryBaseKibanaFeature = getAttackDiscoveryBaseKibanaFeature;