"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeysEmptyPrompt = void 0;
exports.doesErrorIndicateBadQuery = doesErrorIndicateBadQuery;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _doc_link = require("../../../components/doc_link");
var _use_html_id = require("../../../components/use_html_id");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/api_keys/api_keys_grid/api_keys_empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ApiKeysEmptyPrompt = ({
  error,
  readOnly,
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const accordionId = (0, _use_html_id.useHtmlId)('apiKeysEmptyPrompt', 'accordion');
  if (error) {
    if (doesErrorIndicateAPIKeysAreDisabled(error)) {
      return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
        iconType: "warning",
        body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeysEmptyPrompt.disabledErrorMessage",
          defaultMessage: "API keys are disabled.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 17
          }
        })), /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 45,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_doc_link.DocLink, {
          app: "elasticsearch",
          doc: "security-settings.html#api-key-service-settings",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 46,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeysEmptyPrompt.docsLinkText",
          defaultMessage: "Learn how to enable API keys.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 47,
            columnNumber: 19
          }
        })))),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 35,
          columnNumber: 9
        }
      });
    }
    if (doesErrorIndicateUserHasNoPermissionsToManageAPIKeys(error)) {
      return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
        iconType: "lock",
        body: /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeysEmptyPrompt.forbiddenErrorMessage",
          defaultMessage: "You do not have permission to manage API keys.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 15
          }
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 61,
          columnNumber: 9
        }
      });
    }
    const ThrowError = () => {
      throw error;
    };
    const promptHeading = doesErrorIndicateBadQuery(error) ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeysEmptyPrompt.badQueryErrorMessage",
      defaultMessage: "Could not load API keys as the query is incorrect.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeysEmptyPrompt.errorMessage",
      defaultMessage: "Could not load API keys.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    });
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
      iconType: "warning",
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 15
        }
      }, promptHeading),
      actions: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xl",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 99,
          columnNumber: 13
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: accordionId,
        buttonClassName: (0, _css.css)({
          display: 'flex',
          justifyContent: 'center'
        }),
        buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          className: (0, _css.css)({
            fontWeight: euiTheme.font.weight.medium
          }),
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 107,
            columnNumber: 17
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.security.management.apiKeysEmptyPrompt.technicalDetailsButton",
          defaultMessage: "Technical details",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 19
          }
        })),
        arrowDisplay: "right",
        paddingSize: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        textAlign: "left",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(ThrowError, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 19
        }
      }))))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    });
  }
  if (readOnly) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
      iconType: "error",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeysEmptyPrompt.readOnlyEmptyTitle",
        defaultMessage: "You do not have permission to create API keys",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.apiKeysEmptyPrompt.readOnlyEmptyMessage",
        defaultMessage: "Please contact your administrator for more information",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 13
        }
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.EmptyPrompt, {
    iconType: "managementApp",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeysEmptyPrompt.emptyTitle",
      defaultMessage: "Create your first API key",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 11
      }
    })),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.apiKeysEmptyPrompt.emptyMessage",
      defaultMessage: "Allow external services to access the Elastic Stack on your behalf.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 11
      }
    })),
    actions: children,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 5
    }
  });
};
exports.ApiKeysEmptyPrompt = ApiKeysEmptyPrompt;
function doesErrorIndicateAPIKeysAreDisabled(error) {
  var _error$body;
  const message = ((_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) || '';
  return message.indexOf('disabled.feature="api_keys"') !== -1;
}
function doesErrorIndicateUserHasNoPermissionsToManageAPIKeys(error) {
  var _error$body2;
  return ((_error$body2 = error.body) === null || _error$body2 === void 0 ? void 0 : _error$body2.statusCode) === 403;
}
function doesErrorIndicateBadQuery(error) {
  const message = (error === null || error === void 0 ? void 0 : error.message) || '';
  const errorString = (error === null || error === void 0 ? void 0 : error.name) || '';
  return errorString.indexOf('ResponseError') > -1 || message.indexOf('illegal_argument_exception') > -1;
}