"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavePlayground = void 0;
var _reactQuery = require("@tanstack/react-query");
var _common = require("../../common");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSavePlayground = () => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    mutate: savePlayground,
    ...rest
  } = (0, _reactQuery.useMutation)({
    mutationKey: [_common.SearchPlaygroundMutationKeys.SavePlayground],
    mutationFn: async playground => http.put(_common.APIRoutes.PUT_PLAYGROUND_CREATE, {
      body: JSON.stringify(playground),
      version: _common.ROUTE_VERSIONS.v1
    })
  });
  return {
    savePlayground,
    ...rest
  };
};
exports.useSavePlayground = useSavePlayground;