"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useElasticsearchUrl = void 0;
var _react = require("react");
var _searchSharedUi = require("@kbn/search-shared-ui");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useElasticsearchUrl = () => {
  const {
    services: {
      cloud
    }
  } = (0, _use_kibana.useKibana)();
  const [elasticsearchUrl, setElasticsearchUrl] = (0, _react.useState)(_searchSharedUi.ELASTICSEARCH_URL_PLACEHOLDER);
  (0, _react.useEffect)(() => {
    cloud === null || cloud === void 0 ? void 0 : cloud.fetchElasticsearchConfig().then(config => {
      setElasticsearchUrl((config === null || config === void 0 ? void 0 : config.elasticsearchUrl) || _searchSharedUi.ELASTICSEARCH_URL_PLACEHOLDER);
    });
  }, [cloud]);
  return elasticsearchUrl;
};
exports.useElasticsearchUrl = useElasticsearchUrl;