"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SchedulePanel = exports.ConnectorSchedulingComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _connectors = require("../../types/connectors");
var _connector_error = require("./connector_error");
var _connector_unconfigured = require("./connector_unconfigured");
var _full_content = require("./full_content");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/scheduling/connector_scheduling.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SchedulePanel = ({
  title,
  description,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 13
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 13
    }
  }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 11
    }
  }), children)));
};
exports.SchedulePanel = SchedulePanel;
const ConnectorSchedulingComponent = ({
  children,
  connector,
  configurationPathOnClick,
  dataTelemetryIdPrefix,
  hasChanges,
  hasIngestionError,
  hasPlatinumLicense,
  isDisabled,
  setHasChanges,
  shouldShowAccessControlSync,
  shouldShowIncrementalSync,
  updateConnectorStatus,
  updateScheduling
}) => {
  var _connector$configurat;
  const [hasFullSyncChanges, setHasFullSyncChanges] = (0, _react.useState)(false);
  const [hasAccessSyncChanges, setAccessSyncChanges] = (0, _react.useState)(false);
  const [hasIncrementalSyncChanges, setIncrementalSyncChanges] = (0, _react.useState)(false);
  const isDocumentLevelSecurityDisabled = !((_connector$configurat = connector.configuration.use_document_level_security) !== null && _connector$configurat !== void 0 && _connector$configurat.value);
  const hasSyncStatusChanged = (0, _react.useMemo)(() => {
    return hasFullSyncChanges || hasAccessSyncChanges || hasIncrementalSyncChanges;
  }, [hasFullSyncChanges, hasAccessSyncChanges, hasIncrementalSyncChanges]);
  (0, _react.useEffect)(() => {
    if (hasChanges !== hasSyncStatusChanged) {
      setHasChanges(hasSyncStatusChanged);
    }
  }, [hasSyncStatusChanged, hasChanges, setHasChanges]);
  if (connector.status === _connectors.ConnectorStatus.CREATED || connector.status === _connectors.ConnectorStatus.NEEDS_CONFIGURATION) {
    return /*#__PURE__*/_react.default.createElement(_connector_unconfigured.ConnectorUnconfigured, {
      dataTelemetryIdPrefix: "entSearchContent",
      configurationPathOnClick: configurationPathOnClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, hasIngestionError ? /*#__PURE__*/_react.default.createElement(_connector_error.ConnectorError, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 28
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null), children, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(SchedulePanel, {
    title: _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.schedulePanel.contentSync.title', {
      defaultMessage: 'Content sync'
    }),
    description: _i18n.i18n.translate('searchConnectors.content.indices.connectorScheduling.schedulePanel.contentSync.description', {
      defaultMessage: 'Fetch content to create or update your Elasticsearch documents.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_full_content.ConnectorContentScheduling, {
    type: _connectors.SyncJobType.FULL,
    connector: connector,
    setHasChanges: setHasChanges,
    setHasSyncTypeChanges: setHasFullSyncChanges,
    hasSyncTypeChanges: hasFullSyncChanges,
    updateConnectorStatus: updateConnectorStatus,
    updateScheduling: updateScheduling,
    dataTelemetryIdPrefix: dataTelemetryIdPrefix,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 17
    }
  })), shouldShowIncrementalSync && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_full_content.ConnectorContentScheduling, {
    type: _connectors.SyncJobType.INCREMENTAL,
    connector: connector,
    setHasChanges: setHasChanges,
    setHasSyncTypeChanges: setIncrementalSyncChanges,
    hasSyncTypeChanges: hasIncrementalSyncChanges,
    updateConnectorStatus: updateConnectorStatus,
    updateScheduling: updateScheduling,
    dataTelemetryIdPrefix: dataTelemetryIdPrefix,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 19
    }
  }))))), shouldShowAccessControlSync && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(SchedulePanel, {
    title: _i18n.i18n.translate('searchConnectors.connectorScheduling.schedulePanel.documentLevelSecurity.title', {
      defaultMessage: 'Document Level Security'
    }),
    description: _i18n.i18n.translate('searchConnectors.connectorScheduling.schedulePanel.documentLevelSecurity.description', {
      defaultMessage: 'Control the documents users can access, based on their permissions and roles. Schedule syncs to keep these access controls up to date.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_full_content.ConnectorContentScheduling, {
    type: _connectors.SyncJobType.ACCESS_CONTROL,
    connector: connector,
    hasPlatinumLicense: hasPlatinumLicense,
    setHasChanges: setHasChanges,
    setHasSyncTypeChanges: setAccessSyncChanges,
    hasSyncTypeChanges: hasAccessSyncChanges,
    updateConnectorStatus: updateConnectorStatus,
    updateScheduling: updateScheduling,
    dataTelemetryIdPrefix: dataTelemetryIdPrefix,
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 19
    }
  }))), isDocumentLevelSecurityDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('searchConnectors.connectorScheduling.schedulePanel.documentLevelSecurity.dlsDisabledCallout.title', {
      defaultMessage: 'Access control syncs not allowed'
    }),
    color: "warning",
    iconType: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "searchConnectors.connectorScheduling.schedulePanel.documentLevelSecurity.dlsDisabledCallout.text",
    defaultMessage: "{link} for this connector to activate these options.",
    values: {
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: configurationPathOnClick,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 29
        }
      }, _i18n.i18n.translate('searchConnectors.connectorScheduling.schedulePanel.documentLevelSecurity.dlsDisabledCallout.link', {
        defaultMessage: 'Enable document level security'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 23
    }
  }))))))));
};
exports.ConnectorSchedulingComponent = ConnectorSchedulingComponent;