"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serviceDefinition = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _schema = require("../../../saved_objects/schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const savedSearchSavedObjectSchema = (0, _contentManagementUtils.savedObjectSchema)(_schema.SCHEMA_SEARCH_MODEL_VERSION_8);
const savedSearchCreateOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  id: _contentManagementUtils.createOptionsSchemas.id,
  references: _contentManagementUtils.createOptionsSchemas.references,
  overwrite: _contentManagementUtils.createOptionsSchemas.overwrite
}));
const savedSearchUpdateOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  references: _contentManagementUtils.updateOptionsSchema.references
}));
const savedSearchSearchOptionsSchema = _configSchema.schema.maybe(_configSchema.schema.object({
  searchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
}));

// Content management service definition.
// We need it for BWC support between different versions of the content
const serviceDefinition = exports.serviceDefinition = {
  get: {
    out: {
      result: {
        schema: (0, _contentManagementUtils.objectTypeToGetResultSchema)(savedSearchSavedObjectSchema)
      }
    }
  },
  create: {
    in: {
      options: {
        schema: savedSearchCreateOptionsSchema
      },
      data: {
        schema: _schema.SCHEMA_SEARCH_MODEL_VERSION_8
      }
    },
    out: {
      result: {
        schema: (0, _contentManagementUtils.createResultSchema)(savedSearchSavedObjectSchema)
      }
    }
  },
  update: {
    in: {
      options: {
        schema: savedSearchUpdateOptionsSchema
      },
      data: {
        schema: _schema.SCHEMA_SEARCH_MODEL_VERSION_8
      }
    }
  },
  search: {
    in: {
      options: {
        schema: savedSearchSearchOptionsSchema
      }
    }
  },
  mSearch: {
    out: {
      result: {
        schema: savedSearchSavedObjectSchema
      }
    }
  }
};