"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildGetSearchBarFilter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/saved_objects_tagging/public/ui_api/get_search_bar_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const buildGetSearchBarFilter = ({
  getTagList
}) => {
  return ({
    useName = true,
    tagField = 'tag'
  } = {}) => {
    return {
      type: 'field_value_selection',
      field: tagField,
      name: _i18n.i18n.translate('xpack.savedObjectsTagging.uiApi.searchBar.filterButtonLabel', {
        defaultMessage: 'Tags'
      }),
      multiSelect: 'or',
      options: () => {
        // we are using the promise version of `options` because the handler is called
        // everytime the filter is opened. That way we can keep in sync in case of tags
        // that would be added without the searchbar having trigger a re-render.
        return Promise.resolve(getTagList().map(tag => {
          return {
            value: useName ? tag.name : tag.id,
            name: tag.name,
            view: /*#__PURE__*/_react.default.createElement(_components.TagSearchBarOption, {
              tag: tag,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 42,
                columnNumber: 21
              }
            })
          };
        }));
      }
    };
  };
};
exports.buildGetSearchBarFilter = buildGetSearchBarFilter;