"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSuccessToast = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _react = _interopRequireDefault(require("react"));
var _job_download_button = require("./job_download_button");
var _report_link = require("./report_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/notifier/job_success.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getSuccessToast = (job, getReportLink, getDownloadLink, core) => ({
  title: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.reporting.publicNotifier.successfullyCreatedReportNotificationTitle",
    defaultMessage: "{reportType} created for ''{reportObjectTitle}''",
    values: {
      reportType: job.jobtype,
      reportObjectTitle: job.title
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 5
    }
  }), core),
  color: 'success',
  text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_report_link.ReportLink, {
    getUrl: getReportLink,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_job_download_button.DownloadButton, {
    getUrl: getDownloadLink,
    job: job,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  })), core),
  'data-test-subj': 'completeReportSuccess'
});
exports.getSuccessToast = getSuccessToast;