"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IlmPolicyLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _reportingCommon = require("@kbn/reporting-common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/reporting/public/management/components/ilm_policy_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const i18nTexts = {
  buttonLabel: _i18n.i18n.translate('xpack.reporting.listing.reports.ilmPolicyLinkText', {
    defaultMessage: 'Edit ILM policy'
  })
};
const IlmPolicyLink = ({
  locator
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "ilmPolicyLink",
    size: "s",
    iconType: "popout",
    onClick: () => {
      const url = locator.getRedirectUrl({
        page: 'policy_edit',
        policyName: _reportingCommon.ILM_POLICY_NAME
      });
      window.open(url, '_blank');
      window.focus();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 5
    }
  }, i18nTexts.buttonLabel);
};
exports.IlmPolicyLink = IlmPolicyLink;