"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionRow = FunctionRow;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _profilingUtils = require("@kbn/profiling-utils");
var _react = _interopRequireWildcard(require("react"));
var _as_cost = require("../../utils/formatters/as_cost");
var _as_weight = require("../../utils/formatters/as_weight");
var _stack_frame_summary = require("../stack_frame_summary");
var _cpu_stat = require("./cpu_stat");
var _sample_stat = require("./sample_stat");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/topn_functions/function_row.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FunctionRow({
  functionRow,
  columnId,
  totalCount,
  onFrameClick,
  setCellProps
}) {
  if (columnId === _profilingUtils.TopNFunctionSortField.Diff) {
    return /*#__PURE__*/_react.default.createElement(DiffColumn, {
      diff: functionRow.diff,
      setCellProps: setCellProps,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 12
      }
    });
  }
  if (columnId === _profilingUtils.TopNFunctionSortField.Rank) {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 40,
        columnNumber: 12
      }
    }, functionRow.rank);
  }
  if (columnId === _profilingUtils.TopNFunctionSortField.Frame) {
    return /*#__PURE__*/_react.default.createElement(_stack_frame_summary.StackFrameSummary, {
      frame: functionRow.frame,
      onFrameClick: onFrameClick,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 12
      }
    });
  }
  if (columnId === _profilingUtils.TopNFunctionSortField.Samples) {
    var _functionRow$diff;
    return /*#__PURE__*/_react.default.createElement(SamplesColumn, {
      samples: functionRow.samples,
      diffSamples: (_functionRow$diff = functionRow.diff) === null || _functionRow$diff === void 0 ? void 0 : _functionRow$diff.samples,
      totalSamples: totalCount,
      setCellProps: setCellProps,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 7
      }
    });
  }
  if (columnId === _profilingUtils.TopNFunctionSortField.SelfCPU) {
    var _functionRow$diff2;
    return /*#__PURE__*/_react.default.createElement(_cpu_stat.CPUStat, {
      cpu: functionRow.selfCPUPerc,
      diffCPU: (_functionRow$diff2 = functionRow.diff) === null || _functionRow$diff2 === void 0 ? void 0 : _functionRow$diff2.selfCPUPerc,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 12
      }
    });
  }
  if (columnId === _profilingUtils.TopNFunctionSortField.TotalCPU) {
    var _functionRow$diff3;
    return /*#__PURE__*/_react.default.createElement(_cpu_stat.CPUStat, {
      cpu: functionRow.totalCPUPerc,
      diffCPU: (_functionRow$diff3 = functionRow.diff) === null || _functionRow$diff3 === void 0 ? void 0 : _functionRow$diff3.totalCPUPerc,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 12
      }
    });
  }
  if (columnId === _profilingUtils.TopNFunctionSortField.AnnualizedCo2) {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 12
      }
    }, (0, _as_weight.asWeight)(functionRow.totalAnnualCO2kgs, 'kgs'));
  }
  if (columnId === _profilingUtils.TopNFunctionSortField.AnnualizedDollarCost) {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 12
      }
    }, (0, _as_cost.asCost)(functionRow.totalAnnualCostUSD));
  }
  return null;
}
function SamplesColumn({
  samples,
  totalSamples,
  diffSamples,
  setCellProps
}) {
  (0, _react.useEffect)(() => {
    setCellProps({
      css: {
        textAlign: 'right'
      }
    });
  }, [setCellProps]);
  return /*#__PURE__*/_react.default.createElement(_sample_stat.SampleStat, {
    samples: samples,
    diffSamples: diffSamples,
    totalSamples: totalSamples,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 10
    }
  });
}
function DiffColumn({
  diff,
  setCellProps
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const successColor = euiTheme.colors.backgroundBaseSuccess;
  const dangerColor = euiTheme.colors.backgroundBaseDanger;
  (0, _react.useEffect)(() => {
    if (diff && diff.rank !== 0) {
      const color = diff.rank > 0 ? 'success' : 'danger';
      setCellProps({
        style: {
          backgroundColor: color === 'success' ? successColor : dangerColor
        }
      });
    }
  }, [dangerColor, diff, setCellProps, successColor]);
  if (!diff) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: euiTheme.colors.textPrimary,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 7
      }
    }, _i18n.i18n.translate('xpack.profiling.functionsView.newLabel', {
      defaultMessage: 'New'
    }));
  }
  if (diff.rank === 0) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: diff.rank > 0 ? 'sortUp' : 'sortDown',
    color: diff.rank > 0 ? 'success' : 'danger',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, Math.abs(diff.rank))));
}