"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockProfilingDependenciesStorybook = MockProfilingDependenciesStorybook;
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/ml-plugin/public");
var _url_service = require("@kbn/share-plugin/common/url_service");
var _history = require("history");
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _profiling_dependencies_context = require("./profiling_dependencies_context");
var _routing = require("../../../routing");
var _time_range_context = require("../time_range_context");
var _services = require("../../../services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/profiling/public/components/contexts/profiling_dependencies/mock_profiling_dependencies_storybook.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const urlService = new _url_service.UrlService({
  navigate: async () => {},
  getUrl: async ({
    app,
    path
  }, {
    absolute
  }) => {
    return `${absolute ? 'http://localhost:8888' : ''}/app/${app}${path}`;
  },
  shortUrls: () => ({
    get: () => {}
  })
});
const locator = urlService.locators.create(new _public2.MlLocatorDefinition());
const mockPlugin = {
  ml: {
    locator
  },
  data: {
    query: {
      timefilter: {
        timefilter: {
          setTime: () => {},
          getTime: () => ({})
        }
      }
    }
  }
};
const mockCore = {
  uiSettings: {
    get: () => {}
  },
  application: {
    currentAppId$: new _rxjs.Observable(),
    getUrlForApp: appId => '',
    navigateToUrl: url => {}
  },
  chrome: {
    docTitle: {
      change: () => {}
    },
    setBreadcrumbs: () => {},
    setHelpExtension: () => {},
    setBadge: () => {}
  },
  docLinks: {
    DOC_LINK_VERSION: 'current',
    ELASTIC_WEBSITE_URL: 'https://www.elastic.co/',
    links: {
      observability: {
        guide: ''
      }
    }
  },
  http: {
    basePath: {
      prepend: path => `/basepath${path}`,
      get: () => '/basepath'
    }
  },
  i18n: {
    Context: ({
      children
    }) => children
  },
  notifications: {
    toasts: {
      addWarning: () => {},
      addDanger: () => {},
      add: () => {}
    }
  }
};
const mockProfilingDependenciesContext = {
  core: mockCore,
  plugins: mockPlugin
};
function MockProfilingDependenciesStorybook({
  children,
  profilingContext,
  routePath,
  mockServices = {}
}) {
  const contextMock = (0, _lodash.merge)({}, mockProfilingDependenciesContext, profilingContext);
  const KibanaReactContext = (0, _public.createKibanaReactContext)(mockProfilingDependenciesContext.core);
  const history = (0, _history.createMemoryHistory)({
    initialEntries: [routePath || '/stacktraces']
  });
  const services = (0, _services.getServices)();
  return /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(KibanaReactContext.Provider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    router: _routing.profilingRouter,
    history: history,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_time_range_context.TimeRangeContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_profiling_dependencies_context.ProfilingDependenciesContextProvider
  // We should keep adding more stuff to the mock object as we need
  , {
    value: {
      start: contextMock,
      setup: {},
      services: (0, _lodash.merge)({}, services, mockServices)
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, children)))));
}