"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldTypeFilter = FieldTypeFilter;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _fieldUtils = require("@kbn/field-utils");
var _i18nReact = require("@kbn/i18n-react");
var _reactField = require("@kbn/react-field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/presentation_util/public/components/field_picker/field_type_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FieldTypeFilter({
  availableFieldTypes,
  onFieldTypesChange,
  setFocusToSearch,
  fieldTypesValue,
  buttonProps
}) {
  const [isPopoverOpen, setPopoverOpen] = (0, _react.useState)(false);
  const handleFilterButtonClicked = () => {
    setPopoverOpen(!isPopoverOpen);
  };
  const buttonContent = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, (0, _extends2.default)({}, buttonProps, {
    "data-test-subj": "toggleFieldFilterButton",
    iconType: "arrowDown",
    isSelected: isPopoverOpen,
    numFilters: 0,
    hasActiveFilters: fieldTypesValue.length > 0,
    numActiveFilters: fieldTypesValue.length,
    onClick: handleFilterButtonClicked,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "presentationUtil.fieldSearch.fieldFilterButtonLabel",
    defaultMessage: "Filter by type",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    compressed: true,
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    panelPaddingSize: "none",
    display: "block",
    isOpen: isPopoverOpen,
    closePopover: () => {
      setPopoverOpen(false);
    },
    fullWidth: true,
    input: buttonContent,
    focusTrapProps: {
      returnFocus: false,
      // we will be manually returning the focus to the search
      onDeactivation: setFocusToSearch
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: availableFieldTypes.map(type => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: type,
      icon: fieldTypesValue.includes(type) ? 'check' : 'empty',
      "data-test-subj": `typeFilter-${type}`,
      onClick: () => {
        if (fieldTypesValue.includes(type)) {
          onFieldTypesChange(fieldTypesValue.filter(f => f !== type));
        } else {
          onFieldTypesChange([...fieldTypesValue, type]);
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_reactField.FieldIcon, {
      type: type,
      label: type,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 17
      }
    }, (0, _fieldUtils.getFieldTypeName)(type))))),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  })));
}