"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logLevelPalette = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// TODO: update colors to vis colors
const logLevelColors = {
  Emerg: '#F66D64',
  Alert: '#E78E76',
  Crit: '#E7A584',
  Error: '#E7BD91',
  Warn: '#E8D297',
  Notice: '#C7D59',
  Info: '#9CB1D3',
  Debug: '#718FBC',
  Other: '#CED4DE'
};
/**
 * Defines a palette to be used directly and does not fully implement IKbnPalette
 */
const logLevelPalette = exports.logLevelPalette = {
  id: _constants.KbnPalette.LogLevel,
  name: _i18n.i18n.translate('palettes.logLevel.name', {
    defaultMessage: 'Log Level'
  }),
  getColor: key => {
    return logLevelColors[key];
  },
  colors: logLevelColors
};