"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActionResults = void 0;
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _kibana = require("../common/lib/kibana");
var _constants = require("../../common/constants");
var _use_error_toast = require("../common/hooks/use_error_toast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useActionResults = ({
  actionId,
  activePage,
  agentIds,
  direction,
  limit,
  sortField,
  kuery,
  startDate,
  isLive = false
}) => {
  var _agentIds$length;
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const setErrorToast = (0, _use_error_toast.useErrorToast)();
  return (0, _reactQuery.useQuery)(['actionResults', {
    actionId,
    activePage,
    limit,
    direction,
    sortField
  }], () => http.get(`/api/osquery/action_results/${actionId}`, {
    version: _constants.API_VERSIONS.public.v1,
    query: {
      page: activePage,
      pageSize: limit,
      sort: sortField,
      sortOrder: direction,
      ...(kuery && {
        kuery
      }),
      ...(startDate && {
        startDate
      })
      // Note: agentIds NOT included - server fetches from action document
    }
  }), {
    select: response => ({
      edges: response.edges,
      aggregations: response.aggregations,
      inspect: response.inspect || {
        dsl: [],
        response: []
      }
    }),
    initialData: {
      edges: [],
      total: 0,
      aggregations: {
        totalRowCount: 0,
        totalResponded: 0,
        successful: 0,
        pending: (_agentIds$length = agentIds === null || agentIds === void 0 ? void 0 : agentIds.length) !== null && _agentIds$length !== void 0 ? _agentIds$length : 0,
        failed: 0
      },
      inspect: {
        dsl: [],
        response: []
      }
    },
    refetchInterval: isLive ? 5000 : false,
    keepPreviousData: true,
    enabled: !!actionId && !!(agentIds !== null && agentIds !== void 0 && agentIds.length),
    onSuccess: () => setErrorToast(),
    onError: error => setErrorToast(error, {
      title: _i18n.i18n.translate('xpack.osquery.action_results.fetchError', {
        defaultMessage: 'Error while fetching action results'
      })
    })
  });
};
exports.useActionResults = useActionResults;