"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSchemaFromParams = createSchemaFromParams;
var _zod = require("@kbn/zod");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createSchemaFromParams(params) {
  const schemaFields = {};
  for (const [key, param] of Object.entries(params)) {
    let field;
    switch (param.type) {
      case 'text':
      case 'keyword':
        field = _zod.z.string();
        break;
      case 'long':
      case 'integer':
        field = _zod.z.number().int();
        break;
      case 'double':
      case 'float':
        field = _zod.z.number();
        break;
      case 'boolean':
        field = _zod.z.boolean();
        break;
      case 'date':
        field = _zod.z.string().datetime();
        break;
      case 'object':
        field = _zod.z.record(_zod.z.unknown());
        break;
      case 'nested':
        field = _zod.z.array(_zod.z.record(_zod.z.unknown()));
        break;
    }
    if (param.optional) {
      if (param.defaultValue !== undefined) {
        // Use default value instead of making it optional
        field = field.default(param.defaultValue);
      } else {
        // No default value, make it optional
        field = field.optional();
      }
    }
    field = field.describe(param.description);
    schemaFields[key] = field;
  }
  return _zod.z.object(schemaFields).describe('Parameters needed to execute the query');
}