"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OnechatPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _managementSettingsIds = require("@kbn/management-settings-ids");
var _doc_links = require("../common/doc_links");
var _features = require("../common/features");
var _register_locators = require("./locator/register_locators");
var _register = require("./register");
var _services = require("./services");
var _tools = require("./services/tools");
var _open_conversation_flyout = require("./flyout/open_conversation_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class OnechatPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "internalServices", void 0);
    (0, _defineProperty2.default)(this, "setupServices", void 0);
    this.logger = context.logger.get();
  }
  setup(core, deps) {
    var _deps$licenseManageme;
    const isOnechatUiEnabled = core.settings.client.get(_managementSettingsIds.AGENT_BUILDER_ENABLED_SETTING_ID, true);
    const navigationService = new _services.NavigationService({
      management: deps.management.locator,
      licenseManagement: (_deps$licenseManageme = deps.licenseManagement) === null || _deps$licenseManageme === void 0 ? void 0 : _deps$licenseManageme.locator
    });
    this.setupServices = {
      navigationService
    };
    if (isOnechatUiEnabled) {
      (0, _register.registerApp)({
        core,
        getServices: () => {
          if (!this.internalServices) {
            throw new Error('getServices called before plugin start');
          }
          return this.internalServices;
        }
      });
      (0, _register.registerAnalytics)({
        analytics: core.analytics
      });
      (0, _register_locators.registerLocators)(deps.share);
    }
    try {
      core.getStartServices().then(([coreStart]) => {
        const {
          capabilities
        } = coreStart.application;
        if (capabilities[_features.ONECHAT_FEATURE_ID][_features.uiPrivileges.showManagement]) {
          (0, _register.registerManagementSection)({
            core,
            management: deps.management
          });
        }
      });
    } catch (error) {
      this.logger.error('Error registering Agent Builder management section', error);
    }
    return {};
  }
  start(core, startDependencies) {
    const {
      http
    } = core;
    const {
      licensing,
      inference
    } = startDependencies;
    _doc_links.docLinks.setDocLinks(core.docLinks.links);
    const agentService = new _services.AgentService({
      http
    });
    const chatService = new _services.ChatService({
      http
    });
    const conversationsService = new _services.ConversationsService({
      http
    });
    const toolsService = new _services.ToolsService({
      http
    });
    const accessChecker = new _services.AgentBuilderAccessChecker({
      licensing,
      inference
    });
    if (!this.setupServices) {
      throw new Error('plugin start called before plugin setup');
    }
    const {
      navigationService
    } = this.setupServices;
    const internalServices = {
      agentService,
      chatService,
      conversationsService,
      navigationService,
      toolsService,
      startDependencies,
      accessChecker
    };
    this.internalServices = internalServices;
    return {
      tools: (0, _tools.createPublicToolContract)({
        toolsService
      }),
      openConversationFlyout: options => (0, _open_conversation_flyout.openConversationFlyout)(options, {
        coreStart: core,
        services: internalServices,
        startDependencies
      })
    };
  }
}
exports.OnechatPlugin = OnechatPlugin;