"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamMappings = void 0;
var _cleanup_mapping = require("./cleanup_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the mappings for each of the given datastreams.
 */
const getDataStreamMappings = async ({
  datastreams,
  cleanup = true,
  esClient
}) => {
  const response = await esClient.transport.request({
    path: `/_data_stream/${datastreams.join(',')}/_mappings`,
    method: 'GET'
  });
  return response.data_streams.reduce((res, datastream) => {
    const mappings = '_doc' in datastream.effective_mappings ? datastream.effective_mappings._doc : datastream.effective_mappings;
    res[datastream.name] = {
      mappings: cleanup ? (0, _cleanup_mapping.cleanupMapping)(mappings) : mappings
    };
    return res;
  }, {});
};
exports.getDataStreamMappings = getDataStreamMappings;