"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _telemetry_client = require("./telemetry_client");
var _telemetry_events = require("./telemetry_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TelemetryService {
  constructor() {
    (0, _defineProperty2.default)(this, "initialized", false);
  }
  setup(analytics) {
    _telemetry_events.events.forEach(eventConfig => analytics.registerEventType(eventConfig));
    this.initialized = true;
  }
  start(analytics) {
    if (!analytics) {
      throw new Error('Analytics service is not available. Ensure it is started before using TelemetryService.');
    }
    if (!this.initialized) {
      throw new Error('TelemetryService has not been initialized. Call setup() first.');
    }
    return new _telemetry_client.TelemetryClient(analytics);
  }
}
exports.TelemetryService = TelemetryService;