"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsPage = RuleDetailsPage;
var _eui = require("@elastic/eui");
var _common = require("@kbn/alerting-plugin/common");
var _constants = require("@kbn/alerts-ui-shared/src/alert_filter_controls/constants");
var _ebtTools = require("@kbn/ebt-tools");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _flyout = require("@kbn/response-ops-rule-form/flyout");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _common2 = require("../../../common");
var _constants2 = require("../../../common/constants");
var _paths = require("../../../common/locators/paths");
var _center_justified_spinner = require("../../components/center_justified_spinner");
var _use_fetch_rule = require("../../hooks/use_fetch_rule");
var _use_fetch_rule_types = require("../../hooks/use_fetch_rule_types");
var _use_get_filtered_rule_types = require("../../hooks/use_get_filtered_rule_types");
var _use_plugin_context = require("../../hooks/use_plugin_context");
var _get_control_index = require("../../utils/alert_controls/get_control_index");
var _set_status_on_control_configs = require("../../utils/alert_controls/set_status_on_control_configs");
var _update_selected_options = require("../../utils/alert_controls/update_selected_options");
var _alert_summary_widget = require("../../utils/alert_summary_widget");
var _kibana_react = require("../../utils/kibana_react");
var _header_menu = require("../overview/components/header_menu/header_menu");
var _delete_confirmation_modal = require("./components/delete_confirmation_modal");
var _header_actions = require("./components/header_actions");
var _no_rule_found_panel = require("./components/no_rule_found_panel");
var _page_title_content = require("./components/page_title_content");
var _rule_details_tabs = require("./components/rule_details_tabs");
var _constants3 = require("./constants");
var _get_health_color = require("./helpers/get_health_color");
var _is_rule_editable = require("./helpers/is_rule_editable");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/pages/rule_details/rule_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function RuleDetailsPage() {
  var _rule$executionStatus;
  const {
    services
  } = (0, _kibana_react.useKibana)();
  const {
    application: {
      capabilities,
      navigateToUrl,
      navigateToApp
    },
    http: {
      basePath
    },
    share: {
      url: {
        locators
      }
    },
    triggersActionsUi: {
      actionTypeRegistry,
      ruleTypeRegistry,
      getAlertSummaryWidget: AlertSummaryWidget,
      getRuleDefinition: RuleDefinition,
      getRuleStatusPanel: RuleStatusPanel
    },
    serverless
  } = services;
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  const {
    ruleId
  } = (0, _reactRouterDom.useParams)();
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    rule,
    isLoading,
    isError,
    refetch,
    isRefetching,
    isInitialLoading
  } = (0, _use_fetch_rule.useFetchRule)({
    ruleId
  });
  const filteredRuleTypes = (0, _use_get_filtered_rule_types.useGetFilteredRuleTypes)();
  const {
    ruleTypes
  } = (0, _use_fetch_rule_types.useFetchRuleTypes)({
    filterByRuleTypeIds: filteredRuleTypes
  });
  (0, _public.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.alertsLinkText', {
      defaultMessage: 'Alerts'
    }),
    href: basePath.prepend(_paths.paths.observability.alerts),
    deepLinkId: 'observability-overview:alerts'
  }, {
    href: basePath.prepend(_paths.paths.observability.rules),
    text: _i18n.i18n.translate('xpack.observability.breadcrumbs.rulesLinkText', {
      defaultMessage: 'Rules'
    })
  }, {
    text: rule && rule.name
  }], {
    serverless
  });
  const [controlApi, setControlApi] = (0, _react.useState)();
  const [activeTabId, setActiveTabId] = (0, _react.useState)(() => {
    const searchParams = new URLSearchParams(search);
    const urlTabId = searchParams.get(_constants3.RULE_DETAILS_TAB_URL_STORAGE_KEY);
    return urlTabId && [_constants3.RULE_DETAILS_EXECUTION_TAB, _constants3.RULE_DETAILS_ALERTS_TAB].includes(urlTabId) ? urlTabId : _constants3.RULE_DETAILS_ALERTS_TAB;
  });
  const [esQuery, setEsQuery] = (0, _react.useState)();
  const [alertSummaryWidgetTimeRange, setAlertSummaryWidgetTimeRange] = (0, _react.useState)(_alert_summary_widget.getDefaultAlertSummaryTimeRange);
  const [isEditRuleFlyoutVisible, setEditRuleFlyoutVisible] = (0, _react.useState)(false);
  const [ruleToDelete, setRuleToDelete] = (0, _react.useState)(undefined);
  const [isRuleDeleting, setIsRuleDeleting] = (0, _react.useState)(false);
  const tabsRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    setAlertSummaryWidgetTimeRange((0, _alert_summary_widget.getDefaultAlertSummaryTimeRange)());
  }, [esQuery]);
  const handleSetTabId = async tabId => {
    var _locators$get;
    setActiveTabId(tabId);
    await ((_locators$get = locators.get(_common2.ruleDetailsLocatorID)) === null || _locators$get === void 0 ? void 0 : _locators$get.navigate({
      ruleId,
      tabId
    }, {
      replace: true
    }));
  };
  const handleAlertSummaryWidgetClick = async (status = _constants2.ALERT_STATUS_ALL) => {
    var _searchParams$get, _locators$get2, _tabsRef$current;
    setAlertSummaryWidgetTimeRange((0, _alert_summary_widget.getDefaultAlertSummaryTimeRange)());
    const searchParams = new URLSearchParams(search);
    let controlConfigs = (_searchParams$get = searchParams.get('controlConfigs')) !== null && _searchParams$get !== void 0 ? _searchParams$get : _constants.DEFAULT_CONTROLS;
    const statusControlIndex = (0, _get_control_index.getControlIndex)(_ruleDataUtils.ALERT_STATUS, controlConfigs);
    controlConfigs = (0, _set_status_on_control_configs.setStatusOnControlConfigs)(status, controlConfigs);
    (0, _update_selected_options.updateSelectedOptions)(status, statusControlIndex, controlApi);
    await ((_locators$get2 = locators.get(_common2.ruleDetailsLocatorID)) === null || _locators$get2 === void 0 ? void 0 : _locators$get2.navigate({
      controlConfigs,
      rangeFrom: _alert_summary_widget.defaultTimeRange.from,
      rangeTo: _alert_summary_widget.defaultTimeRange.to,
      ruleId,
      tabId: _constants3.RULE_DETAILS_ALERTS_TAB
    }, {
      replace: true
    }));
    setActiveTabId(_constants3.RULE_DETAILS_ALERTS_TAB);
    (_tabsRef$current = tabsRef.current) === null || _tabsRef$current === void 0 ? void 0 : _tabsRef$current.scrollIntoView({
      behavior: 'smooth'
    });
  };
  const handleEditRule = () => {
    if (rule) {
      navigateToApp('observability', {
        path: _paths.relativePaths.observability.editRule(rule.id),
        state: {
          returnApp: 'observability',
          returnPath: _paths.relativePaths.observability.ruleDetails(rule.id)
        }
      });
    }
  };
  const handleCloseRuleFlyout = () => {
    setEditRuleFlyoutVisible(false);
  };
  const handleDeleteRule = () => {
    setRuleToDelete(rule === null || rule === void 0 ? void 0 : rule.id);
    setEditRuleFlyoutVisible(false);
  };
  const handleIsDeletingRule = () => {
    setIsRuleDeleting(true);
  };
  const handleIsRuleDeleted = () => {
    setRuleToDelete(undefined);
    setIsRuleDeleting(false);
    navigateToUrl(basePath.prepend(_paths.paths.observability.rules));
  };
  const ruleType = ruleTypes === null || ruleTypes === void 0 ? void 0 : ruleTypes.find(type => type.id === (rule === null || rule === void 0 ? void 0 : rule.ruleTypeId));
  const isEditable = (0, _is_rule_editable.isRuleEditable)({
    capabilities,
    rule,
    ruleType,
    ruleTypeRegistry
  });
  const ruleStatusMessage = (rule === null || rule === void 0 ? void 0 : (_rule$executionStatus = rule.executionStatus.error) === null || _rule$executionStatus === void 0 ? void 0 : _rule$executionStatus.reason) === _common.RuleExecutionStatusErrorReasons.License ? rulesStatusesTranslationsMapping.noLicense : rule ? rulesStatusesTranslationsMapping[rule.executionStatus.status] : '';
  (0, _ebtTools.usePageReady)({
    isReady: !isInitialLoading,
    isRefreshing: isRefetching,
    meta: {
      description: '[ttfmp_rule_details] The Observability Rule Details overview page has loaded successfully.'
    }
  });
  if (isLoading || isRuleDeleting) return /*#__PURE__*/_react.default.createElement(_center_justified_spinner.CenterJustifiedSpinner, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 43
    }
  });
  if (!rule || isError) return /*#__PURE__*/_react.default.createElement(_no_rule_found_panel.NoRuleFoundPanel, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 32
    }
  });
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    "data-test-subj": "ruleDetails",
    pageHeader: {
      pageTitle: rule.name,
      pageTitleProps: {
        'data-test-subj': 'ruleName'
      },
      children: /*#__PURE__*/_react.default.createElement(_page_title_content.PageTitleContent, {
        rule: rule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 241,
          columnNumber: 19
        }
      }),
      bottomBorder: false,
      rightSideItems: ruleId ? [/*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, {
        ruleId: ruleId,
        isLoading: isLoading || isRuleDeleting,
        isRuleEditable: isEditable,
        onEditRule: handleEditRule,
        onDeleteRule: handleDeleteRule,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 245,
          columnNumber: 15
        }
      })] : []
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_header_menu.HeaderMenu, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "m",
    "data-test-subj": `ruleType_${rule.ruleTypeId}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 350
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(RuleStatusPanel, {
    rule: rule,
    isEditable: isEditable,
    requestRefresh: refetch,
    healthColor: (0, _get_health_color.getHealthColor)(rule.executionStatus.status),
    statusMessage: ruleStatusMessage,
    autoRecoverAlerts: ruleType === null || ruleType === void 0 ? void 0 : ruleType.autoRecoverAlerts,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: {
      minWidth: 350
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(AlertSummaryWidget, {
    ruleTypeIds: _constants2.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    consumers: _constants2.observabilityAlertFeatureIds,
    onClick: handleAlertSummaryWidgetClick,
    timeRange: alertSummaryWidgetTimeRange,
    filter: {
      term: {
        'kibana.alert.rule.uuid': ruleId
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 270,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(RuleDefinition, {
    actionTypeRegistry: actionTypeRegistry,
    rule: rule,
    ruleTypeRegistry: ruleTypeRegistry,
    navigateToEditRuleForm: handleEditRule,
    onEditRule: async () => {
      refetch();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 283,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: tabsRef,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rule_details_tabs.RuleDetailsTabs, {
    esQuery: esQuery,
    ruleTypeIds: _constants2.OBSERVABILITY_RULE_TYPE_IDS_WITH_SUPPORTED_STACK_RULE_TYPES,
    rule: rule,
    ruleId: ruleId,
    ruleType: ruleType,
    activeTabId: activeTabId,
    onEsQueryChange: setEsQuery,
    onSetTabId: handleSetTabId,
    onControlApiAvailable: setControlApi,
    controlApi: controlApi,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 7
    }
  }), isEditRuleFlyoutVisible && /*#__PURE__*/_react.default.createElement(_flyout.RuleFormFlyout, {
    plugins: {
      ...services,
      actionTypeRegistry,
      ruleTypeRegistry
    },
    id: rule.id,
    onCancel: handleCloseRuleFlyout,
    onSubmit: () => {
      handleCloseRuleFlyout();
      refetch();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 312,
      columnNumber: 9
    }
  }), ruleToDelete ? /*#__PURE__*/_react.default.createElement(_delete_confirmation_modal.DeleteConfirmationModal, {
    ruleIdToDelete: ruleToDelete,
    title: rule.name,
    onCancel: () => setRuleToDelete(undefined),
    onDeleting: handleIsDeletingRule,
    onDeleted: handleIsRuleDeleted,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }) : null);
}
const rulesStatusesTranslationsMapping = {
  ok: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusOk', {
    defaultMessage: 'Ok'
  }),
  active: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusActive', {
    defaultMessage: 'Active'
  }),
  error: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusError', {
    defaultMessage: 'Error'
  }),
  pending: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusPending', {
    defaultMessage: 'Pending'
  }),
  unknown: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusUnknown', {
    defaultMessage: 'Unknown'
  }),
  warning: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusWarning', {
    defaultMessage: 'Warning'
  }),
  noLicense: _i18n.i18n.translate('xpack.observability.ruleDetails.ruleStatusLicenseError', {
    defaultMessage: 'License Error'
  })
};