"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAlertData = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _constants = require("@kbn/rule-registry-plugin/common/constants");
var _use_data_fetcher = require("./use_data_fetcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchAlertData = alertIds => {
  const validIds = (0, _react.useMemo)(() => getValidValues(alertIds), [alertIds]);
  const shouldExecuteApiCall = (0, _react.useCallback)(ids => ids.length > 0, []);
  const {
    loading,
    data: alerts
  } = (0, _use_data_fetcher.useDataFetcher)({
    paramsForApiCall: validIds,
    initialDataState: undefined,
    executeApiCall: fetchAlerts,
    shouldExecuteApiCall
  });
  return [loading, alerts !== null && alerts !== void 0 ? alerts : {}];
};
exports.useFetchAlertData = useFetchAlertData;
const fetchAlerts = async (ids, abortCtrl, http) => {
  try {
    const response = await http.post(`${_constants.BASE_RAC_ALERTS_API_PATH}/find`, {
      body: JSON.stringify({
        query: {
          ids: {
            values: ids
          }
        },
        track_total_hits: false,
        size: 10000
      }),
      signal: abortCtrl.signal
    });
    if (response) {
      return getAlertsGroupedById(response);
    }
  } catch (error) {
    // ignore the failure
  }
};
const getAlertsGroupedById = data => {
  return data.hits.hits.reduce((acc, {
    _id,
    _index,
    _source
  }) => ({
    ...acc,
    [_id]: {
      _id,
      _index,
      ..._source
    }
  }), {});
};
const getValidValues = ids => {
  return ids.filter(id => !(0, _lodash.isEmpty)(id));
};