"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatePickerContext = void 0;
exports.DatePickerContextProvider = DatePickerContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _useMount = _interopRequireDefault(require("react-use/lib/useMount"));
var _reactRouterDom = require("react-router-dom");
var _queryString = require("query-string");
var _public = require("@kbn/kibana-react-plugin/public");
var _ = require("../..");
var _date = require("../../utils/date");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/observability/public/context/date_picker_context/date_picker_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * This context contains the time range (both relative and absolute) and the
 * autorefresh status of the overview page date picker.
 * It also updates the URL when any of the values change
 */
const DatePickerContext = exports.DatePickerContext = /*#__PURE__*/(0, _react.createContext)({});
function DatePickerContextProvider({
  children
}) {
  var _sharedTimeRange$from, _sharedTimeRange$to, _sharedRefreshInterva;
  const location = (0, _reactRouterDom.useLocation)();
  const history = (0, _reactRouterDom.useHistory)();
  const updateUrl = (0, _react.useCallback)((nextQuery, isFirstRender = false) => {
    const newHistory = {
      ...location,
      search: (0, _.fromQuery)({
        ...(0, _.toQuery)(location.search),
        ...nextQuery
      })
    };
    if (isFirstRender) {
      history.replace(newHistory);
    } else {
      history.push(newHistory);
    }
  }, [history, location]);
  const [lastUpdated, setLastUpdated] = (0, _react.useState)(Date.now());
  const {
    data
  } = (0, _public.useKibana)().services;
  const defaultTimeRange = data.query.timefilter.timefilter.getTimeDefaults();
  const sharedTimeRange = data.query.timefilter.timefilter.getTime();
  const defaultRefreshInterval = data.query.timefilter.timefilter.getRefreshIntervalDefaults();
  const sharedRefreshInterval = data.query.timefilter.timefilter.getRefreshInterval();
  const {
    rangeFrom = (_sharedTimeRange$from = sharedTimeRange.from) !== null && _sharedTimeRange$from !== void 0 ? _sharedTimeRange$from : defaultTimeRange.from,
    rangeTo = (_sharedTimeRange$to = sharedTimeRange.to) !== null && _sharedTimeRange$to !== void 0 ? _sharedTimeRange$to : defaultTimeRange.to,
    refreshInterval = sharedRefreshInterval.value || defaultRefreshInterval.value || 10000,
    // we want to override a default of 0
    refreshPaused = (_sharedRefreshInterva = sharedRefreshInterval.pause) !== null && _sharedRefreshInterva !== void 0 ? _sharedRefreshInterva : defaultRefreshInterval.pause
  } = (0, _queryString.parse)(location.search, {
    sort: false
  });
  const relativeStart = rangeFrom;
  const relativeEnd = rangeTo;
  const absoluteStart = (0, _react.useMemo)(() => (0, _date.getAbsoluteTime)(relativeStart),
  // `lastUpdated` works as a cache buster
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [relativeStart, lastUpdated]);
  const absoluteEnd = (0, _react.useMemo)(() => (0, _date.getAbsoluteTime)(relativeEnd, {
    roundUp: true
  }),
  // `lastUpdated` works as a cache buster
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [relativeEnd, lastUpdated]);
  const updateTimeRange = (0, _react.useCallback)(({
    start,
    end
  }) => {
    data.query.timefilter.timefilter.setTime({
      from: start,
      to: end
    });
    updateUrl({
      rangeFrom: start,
      rangeTo: end
    });
    setLastUpdated(Date.now());
  }, [data.query.timefilter.timefilter, updateUrl]);
  const updateRefreshInterval = (0, _react.useCallback)(({
    interval,
    isPaused
  }) => {
    updateUrl({
      refreshInterval: interval,
      refreshPaused: isPaused
    });
    data.query.timefilter.timefilter.setRefreshInterval({
      value: interval,
      pause: isPaused
    });
    setLastUpdated(Date.now());
  }, [data.query.timefilter.timefilter, updateUrl]);
  (0, _useMount.default)(() => {
    updateUrl({
      rangeFrom: relativeStart,
      rangeTo: relativeEnd
    }, true);
  });
  return /*#__PURE__*/_react.default.createElement(DatePickerContext.Provider, {
    value: {
      relativeStart,
      relativeEnd,
      absoluteStart,
      absoluteEnd,
      refreshInterval: parseRefreshInterval(refreshInterval),
      refreshPaused: parseRefreshPaused(refreshPaused),
      updateTimeRange,
      updateRefreshInterval,
      lastUpdated
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, children);
}
function parseRefreshInterval(value) {
  switch (typeof value) {
    case 'number':
      return value;
    case 'string':
      return parseInt(value, 10) || 0;
    default:
      return 0;
  }
}
function parseRefreshPaused(value) {
  if (typeof value === 'boolean') {
    return value;
  }
  switch (value) {
    case 'false':
      return false;
    case 'true':
    default:
      return true;
  }
}