"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sparkline = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _polished = require("polished");
var _eui = require("@elastic/eui");
var _sparkline_flot_chart = require("./sparkline_flot_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/sparkline/index.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// TODO: Replace with EUI tooltip
const sparklineTooltipStyle = theme => (0, _react2.css)`
  font-weight: ${theme.euiTheme.font.weight.regular};
  background: ${(0, _polished.transparentize)(0.3, theme.euiTheme.colors.darkestShade)};
  font-size: ${(0, _eui.euiFontSize)(theme, 'xs').fontSize};
  padding: ${theme.euiTheme.size.xs};
  border-radius: ${theme.euiTheme.border.radius.medium};
  pointer-events: none;
`;
const tooltipXValueStyle = ({
  euiTheme
}) => (0, _react2.css)`
  color: ${(0, _polished.transparentize)(0.3, euiTheme.colors.ghost)};
`;
const tooltipYValueStyle = ({
  euiTheme
}) => (0, _react2.css)`
  color: ${euiTheme.colors.ghost};
`;
const tooltipContainerStyle = ({
  euiTheme
}) => (0, _react2.css)`
  position: fixed;
  z-index: ${euiTheme.levels.menu};
  display: flex;
  flex-direction: row;
  justify-content: center;
  align-items: center;
`;
const tooltipCaretStyle = theme => (0, _react2.css)`
  font-size: ${(0, _eui.euiFontSize)(theme, 'l').fontSize};
  color: ${(0, _polished.transparentize)(0.3, theme.euiTheme.colors.darkestShade)};
  display: none;
`;
class Sparkline extends _react.default.Component {
  constructor(props) {
    super(props);
    this.makeSparklineFlotChart = this.makeSparklineFlotChart.bind(this);
    this.onHover = this.onHover.bind(this);
    this.renderTooltip = this.renderTooltip.bind(this);
    this.handleSparklineRef = this.handleSparklineRef.bind(this);
    this.state = {
      tooltip: undefined
    };
  }
  UNSAFE_componentWillReceiveProps({
    series,
    options
  }) {
    if (!(0, _lodash.isEqual)(options, this.props.options)) {
      this.sparklineFlotChart.shutdown();
      this.makeSparklineFlotChart(options);
    }
    if (!(0, _lodash.isEqual)(series, this.props.series)) {
      this.sparklineFlotChart.update(series);
    }
  }
  makeSparklineFlotChart(overrideFlotOptions) {
    this.sparklineFlotChart = new _sparkline_flot_chart.SparklineFlotChart(this.chartElem, this.props.series, this.props.onBrush, this.onHover, overrideFlotOptions);
  }
  onHover(dataPoint) {
    this.setState({
      tooltip: dataPoint
    });
  }
  renderTooltip() {
    if (this.props.tooltip.enabled === false) {
      return;
    }
    if (!this.state.tooltip) {
      return;
    }
    const tooltipHeightInPx = 56;
    const tooltipWidthInPx = 220;
    const caretWidthInPx = 6;
    const marginBetweenPointAndCaretInPx = 10;
    const styles = {
      tooltipContainer: {
        top: this.state.tooltip.yPosition - tooltipHeightInPx / 2
      },
      tooltip: {
        height: tooltipHeightInPx,
        width: tooltipWidthInPx
      },
      leftCaret: {
        width: caretWidthInPx
      },
      rightCaret: {
        width: caretWidthInPx
      }
    };
    const plotMiddleX = this.state.tooltip.plotLeft + this.state.tooltip.plotWidth / 2;
    const tooltipContainerWidthInPx = tooltipWidthInPx + caretWidthInPx;
    if (this.state.tooltip.xPosition > plotMiddleX) {
      // The point is in the right half of the plot; position the tooltip
      // to the left of the point
      styles.rightCaret.display = 'block';
      styles.tooltipContainer.left = this.state.tooltip.xPosition - tooltipContainerWidthInPx - marginBetweenPointAndCaretInPx;
    } else {
      // The point is in the left half of the plot; position the tooltip
      // to the right of the point
      styles.leftCaret.display = 'block';
      styles.tooltipContainer.left = this.state.tooltip.xPosition + marginBetweenPointAndCaretInPx;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "monSparklineTooltip__container",
      css: tooltipContainerStyle,
      style: styles.tooltipContainer,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("i", {
      className: "fa fa-caret-left",
      css: tooltipCaretStyle,
      style: styles.leftCaret,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 141,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement("div", {
      css: sparklineTooltipStyle,
      style: styles.tooltip,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: tooltipYValueStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 11
      }
    }, this.props.tooltip.yValueFormatter(this.state.tooltip.yValue)), /*#__PURE__*/_react.default.createElement("div", {
      css: tooltipXValueStyle,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 11
      }
    }, this.props.tooltip.xValueFormatter(this.state.tooltip.xValue))), /*#__PURE__*/_react.default.createElement("i", {
      className: "fa fa-caret-right",
      css: tooltipCaretStyle,
      style: styles.rightCaret,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 150,
        columnNumber: 9
      }
    }));
  }
  handleSparklineRef(elem) {
    this.chartElem = elem;
    if (this.chartElem) {
      this.makeSparklineFlotChart(this.props.options);
    } else if (this.sparklineFlotChart) {
      this.sparklineFlotChart.shutdown();
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: {
        height: '2em'
      },
      ref: this.handleSparklineRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 9
      }
    }), this.renderTooltip());
  }
}
exports.Sparkline = Sparkline;
Sparkline.propTypes = {
  series: _propTypes.default.arrayOf(_propTypes.default.arrayOf(_propTypes.default.number)).isRequired,
  tooltip: _propTypes.default.shape({
    enabled: _propTypes.default.bool,
    xValueFormatter: _propTypes.default.func,
    yValueFormatter: _propTypes.default.func
  }),
  options: _propTypes.default.shape({
    xaxis: _propTypes.default.shape({
      min: _propTypes.default.number,
      max: _propTypes.default.number
    })
  })
};