"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatafeedDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _ml_job_editor = require("../../../../../../jobs_list/components/ml_job_editor");
var _job_utils = require("../../../../../../../../../common/util/job_utils");
var _new_job = require("../../../../../../../../../common/constants/new_job");
var _ml_server_info = require("../../../../../../../services/ml_server_info");
var _common = require("../common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/summary_step/components/datafeed_details/datafeed_details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EDITOR_HEIGHT = '200px';
const DatafeedDetails = () => {
  const {
    jobCreator
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const {
    datafeeds
  } = (0, _ml_server_info.getNewJobDefaults)();
  const queryString = JSON.stringify(jobCreator.query, null, 2);
  const defaultFrequency = (0, _job_utils.calculateDatafeedFrequencyDefaultSeconds)(jobCreator.bucketSpanMs / 1000);
  const scrollSizeDefault = datafeeds.scroll_size || '';
  const queryDelay = jobCreator.queryDelay || /*#__PURE__*/_react.default.createElement(_common.Italic, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, `${_new_job.DEFAULT_QUERY_DELAY} (${_common.defaultLabel})`);
  const frequency = jobCreator.frequency || /*#__PURE__*/_react.default.createElement(_common.Italic, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, `${defaultFrequency}s (${_common.defaultLabel})`);
  const scrollSize = jobCreator.scrollSize !== null ? `${jobCreator.scrollSize}` : /*#__PURE__*/_react.default.createElement(_common.Italic, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, `${scrollSizeDefault} (${_common.defaultLabel})`);
  const datafeedDetails = [{
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.datafeedDetails.timeField.title', {
      defaultMessage: 'Time field'
    }),
    description: jobCreator.timeFieldName
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.datafeedDetails.queryDelay.title', {
      defaultMessage: 'Query delay'
    }),
    description: queryDelay
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.datafeedDetails.frequency.title', {
      defaultMessage: 'Frequency'
    }),
    description: frequency
  }, {
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.datafeedDetails.scrollSize.title', {
      defaultMessage: 'Scroll size'
    }),
    description: scrollSize
  }];
  const queryTitle = _i18n.i18n.translate('xpack.ml.newJob.wizard.summaryStep.datafeedDetails.query.title', {
    defaultMessage: 'Elasticsearch query'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: queryTitle,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: queryString,
    height: EDITOR_HEIGHT,
    readOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    compressed: true,
    listItems: datafeedDetails,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  })));
};
exports.DatafeedDetails = DatafeedDetails;