"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategorizationPerPartitionField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _job_creator_context = require("../../../job_creator_context");
var _job_creator = require("../../../../../common/job_creator");
var _description = require("./description");
var _categorization_per_partition_switch = require("./categorization_per_partition_switch");
var _categorization_stop_on_warn_switch = require("./categorization_stop_on_warn_switch");
var _categorization_per_partition_dropdown = require("./categorization_per_partition_dropdown");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/categorization_partition_field/categorization_per_partition.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CategorizationPerPartitionField = () => {
  const {
    jobCreator: jc,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const jobCreator = jc;
  const [enablePerPartitionCategorization, setEnablePerPartitionCategorization] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setEnablePerPartitionCategorization(jobCreator.perPartitionCategorization);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_categorization_per_partition_switch.CategorizationPerPartitionSwitch, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 9
    }
  })), enablePerPartitionCategorization && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.newJob.wizard.extraStep.categorizationJob.stopOnWarnLabel",
      defaultMessage: "Stop on warn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 15
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_categorization_stop_on_warn_switch.CategorizationPerPartitionStopOnWarnSwitch, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }))), (0, _job_creator.isCategorizationJobCreator)(jobCreator) && enablePerPartitionCategorization && /*#__PURE__*/_react.default.createElement(_categorization_per_partition_dropdown.CategorizationPerPartitionFieldDropdown, {
    setEnablePerPartitionCategorization: setEnablePerPartitionCategorization,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }));
};
exports.CategorizationPerPartitionField = CategorizationPerPartitionField;