"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditJobFlyoutUI = exports.EditJobFlyout = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _tabs = require("./tabs");
var _edit_utils = require("./edit_utils");
var _utils = require("../utils");
var _validate_job = require("../validate_job");
var _toast_notification_service = require("../../../../services/toast_notification_service");
var _public2 = require("@kbn/es-ui-shared-plugin/public");
var _states = require("../../../../../../common/constants/states");
var _custom_urls = require("../../../../components/custom_urls");
var _jobs_utils = require("../../../jobs_utils");
var _managed_jobs_warning_callout = require("../confirm_modals/managed_jobs_warning_callout");
var _create_focus_trap_props = require("../../../../util/create_focus_trap_props");
var _create_focus_restoration = require("../../../../util/create_focus_restoration");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/jobs_list/components/edit_job_flyout/edit_job_flyout.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  collapseLiteralStrings
} = _public2.XJson;
class EditJobFlyoutUI extends _react.Component {
  constructor(props, constructorContext) {
    super(props, constructorContext);
    (0, _defineProperty2.default)(this, "_initialJobFormState", null);
    (0, _defineProperty2.default)(this, "closeFlyout", (isConfirmed = false) => {
      if (this.containsUnsavedChanges() && !isConfirmed) {
        this.setState({
          isConfirmationModalVisible: true
        });
        return;
      }
      this.setState({
        isConfirmationModalVisible: false
      });
      this.setState({
        isFlyoutVisible: false
      });
    });
    (0, _defineProperty2.default)(this, "showFlyout", jobLite => {
      const hasDatafeed = jobLite.hasDatafeed;
      (0, _utils.loadFullJob)(this.props.kibana.services.mlServices.mlApi, jobLite.id).then(job => {
        this.extractJob(job, hasDatafeed);
        this.setState({
          job,
          isFlyoutVisible: true
        });
      }).catch(error => {
        console.error(error);
      });
    });
    (0, _defineProperty2.default)(this, "setJobDetails", jobDetails => {
      let {
        jobModelMemoryLimitValidationError,
        jobGroupsValidationError
      } = this.state;
      if (jobDetails.jobModelMemoryLimit !== undefined) {
        jobModelMemoryLimitValidationError = (0, _validate_job.validateModelMemoryLimit)(jobDetails.jobModelMemoryLimit).message;
      }
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      if (jobDetails.jobGroups !== undefined) {
        jobGroupsValidationError = (0, _validate_job.validateGroupNames)(jobDetails.jobGroups).message;
        if (jobGroupsValidationError === '') {
          mlApi.jobs.jobsExist(jobDetails.jobGroups, true).then(resp => {
            const groups = Object.values(resp);
            const valid = groups.some(g => g.exists === true && g.isGroup === false) === false;
            if (valid === false) {
              this.setState({
                jobGroupsValidationError: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.groupsAndJobsHasSameIdErrorMessage', {
                  defaultMessage: 'A job with this ID already exists. Groups and jobs cannot use the same ID.'
                }),
                isValidJobDetails: false
              });
            }
          });
        }
      }
      const isValidJobDetails = jobModelMemoryLimitValidationError === '' && jobGroupsValidationError === '';
      this.setState({
        ...jobDetails,
        jobModelMemoryLimitValidationError,
        jobGroupsValidationError,
        isValidJobDetails
      });
    });
    (0, _defineProperty2.default)(this, "setDetectorDescriptions", jobDetectorDescriptions => {
      this.setState({
        ...jobDetectorDescriptions
      });
    });
    (0, _defineProperty2.default)(this, "setDatafeed", datafeed => {
      this.setState({
        ...datafeed
      });
    });
    (0, _defineProperty2.default)(this, "setCustomUrls", jobCustomUrls => {
      const isValidJobCustomUrls = (0, _custom_urls.isValidCustomUrls)(jobCustomUrls);
      this.setState({
        jobCustomUrls,
        isValidJobCustomUrls
      });
    });
    (0, _defineProperty2.default)(this, "save", () => {
      const newJobData = {
        description: this.state.jobDescription,
        groups: this.state.jobGroups,
        mml: this.state.jobModelMemoryLimit,
        modelSnapshotRetentionDays: this.state.jobModelSnapshotRetentionDays,
        dailyModelSnapshotRetentionAfterDays: this.state.jobDailyModelSnapshotRetentionAfterDays,
        detectorDescriptions: this.state.jobDetectorDescriptions,
        datafeedQuery: collapseLiteralStrings(this.state.datafeedQuery),
        datafeedQueryDelay: this.state.datafeedQueryDelay,
        datafeedFrequency: this.state.datafeedFrequency,
        datafeedScrollSize: this.state.datafeedScrollSize,
        customUrls: this.state.jobCustomUrls
      };
      const mlApi = this.props.kibana.services.mlServices.mlApi;
      const {
        toasts
      } = this.props.kibana.services.notifications;
      const toastNotificationService = (0, _toast_notification_service.toastNotificationServiceProvider)(toasts);
      (0, _edit_utils.saveJob)(mlApi, this.state.job, newJobData).then(() => {
        toasts.addSuccess(_i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.changesSavedNotificationMessage', {
          defaultMessage: 'Changes to {jobId} saved',
          values: {
            jobId: this.state.job.job_id
          }
        }));
        this.refreshJobs();
        this.closeFlyout(true);
      }).catch(error => {
        console.error(error);
        toastNotificationService.displayErrorToast(error, _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.changesNotSavedNotificationMessage', {
          defaultMessage: 'Could not save changes to {jobId}',
          values: {
            jobId: this.state.job.job_id
          }
        }));
      });
    });
    this.state = {
      job: {},
      hasDatafeed: false,
      datafeedRunning: false,
      isFlyoutVisible: false,
      isConfirmationModalVisible: false,
      jobDescription: '',
      jobGroups: [],
      jobModelMemoryLimit: '',
      jobModelSnapshotRetentionDays: 10,
      jobDailyModelSnapshotRetentionAfterDays: 10,
      jobDetectors: [],
      jobDetectorDescriptions: [],
      jobCustomUrls: [],
      datafeedQuery: '',
      datafeedQueryDelay: '',
      datafeedFrequency: '',
      datafeedScrollSize: '',
      jobModelMemoryLimitValidationError: '',
      jobGroupsValidationError: '',
      isValidJobDetails: true,
      isValidJobCustomUrls: true
    };
    this.refreshJobs = this.props.refreshJobs;
  }
  componentDidMount() {
    if (typeof this.props.setShowFunction === 'function') {
      this.props.setShowFunction(this.showFlyout);
    }
  }
  componentWillUnmount() {
    if (typeof this.props.unsetShowFunction === 'function') {
      this.props.unsetShowFunction();
    }
  }
  /**
   * Checks if there are any unsaved changes.
   * @returns {boolean}
   */
  containsUnsavedChanges() {
    return !(0, _lodash.isEqual)(this._initialJobFormState, (0, _lodash.pick)(this.state, ['jobDescription', 'jobGroups', 'jobModelMemoryLimit', 'jobModelSnapshotRetentionDays', 'jobDailyModelSnapshotRetentionAfterDays', 'jobCustomUrls', 'jobDetectors', 'jobDetectorDescriptions', 'jobBucketSpan', 'datafeedQuery', 'datafeedQueryDelay', 'datafeedFrequency', 'datafeedScrollSize']));
  }
  extractInitialJobFormState(job, hasDatafeed) {
    const mml = job.analysis_limits && job.analysis_limits.model_memory_limit ? job.analysis_limits.model_memory_limit : '';
    const modelSnapshotRetentionDays = job.model_snapshot_retention_days !== undefined ? job.model_snapshot_retention_days : 10;
    const dailyModelSnapshotRetentionAfterDays = job.daily_model_snapshot_retention_after_days !== undefined ? job.daily_model_snapshot_retention_after_days : modelSnapshotRetentionDays;
    const detectors = job.analysis_config && job.analysis_config.detectors ? [...job.analysis_config.detectors] : [];
    const bucketSpan = job.analysis_config ? job.analysis_config.bucket_span : '';
    const datafeedConfig = {
      ...job.datafeed_config
    };
    const frequency = datafeedConfig.frequency !== undefined ? datafeedConfig.frequency : '';
    const customUrls = job.custom_settings && job.custom_settings.custom_urls ? [...job.custom_settings.custom_urls] : [];
    this._initialJobFormState = Object.freeze({
      jobDescription: job.description,
      jobGroups: job.groups !== undefined ? job.groups : [],
      jobModelMemoryLimit: mml,
      jobModelSnapshotRetentionDays: modelSnapshotRetentionDays,
      jobDailyModelSnapshotRetentionAfterDays: dailyModelSnapshotRetentionAfterDays,
      jobDetectors: detectors,
      jobDetectorDescriptions: detectors.map(d => d.detector_description),
      jobBucketSpan: bucketSpan,
      jobCustomUrls: customUrls,
      datafeedQuery: hasDatafeed ? JSON.stringify(datafeedConfig.query, null, 2) : '',
      datafeedQueryDelay: hasDatafeed ? datafeedConfig.query_delay : '',
      datafeedFrequency: hasDatafeed ? frequency : '',
      datafeedScrollSize: hasDatafeed ? +datafeedConfig.scroll_size : null
    });
  }
  extractJob(job, hasDatafeed) {
    this.extractInitialJobFormState(job, hasDatafeed);
    const datafeedRunning = hasDatafeed && job.datafeed_config.state !== _states.DATAFEED_STATE.STOPPED;
    const jobClosed = job.state === _states.JOB_STATE.CLOSED;
    this.setState({
      job,
      hasDatafeed,
      datafeedRunning,
      jobClosed,
      jobModelMemoryLimitValidationError: '',
      jobGroupsValidationError: '',
      ...(0, _lodash.cloneDeep)(this._initialJobFormState)
    });
  }
  render() {
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    let flyout;
    let confirmationModal;
    if (this.state.isFlyoutVisible) {
      const {
        job,
        jobDescription,
        jobGroups,
        jobModelMemoryLimit,
        jobModelSnapshotRetentionDays,
        jobDailyModelSnapshotRetentionAfterDays,
        jobDetectors,
        jobDetectorDescriptions,
        jobBucketSpan,
        jobCustomUrls,
        datafeedQuery,
        datafeedQueryDelay,
        datafeedFrequency,
        datafeedScrollSize,
        jobGroupsValidationError,
        jobModelMemoryLimitValidationError,
        isValidJobDetails,
        isValidJobCustomUrls,
        datafeedRunning,
        jobClosed
      } = this.state;
      const tabs = [{
        id: 'job-details',
        'data-test-subj': 'mlEditJobFlyout-jobDetails',
        name: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.jobDetailsTitle', {
          defaultMessage: 'Job details'
        }),
        content: /*#__PURE__*/_react.default.createElement(_tabs.EditJobDetailsTab, {
          euiTheme: this.props.euiTheme,
          jobClosed: jobClosed,
          datafeedRunning: datafeedRunning,
          jobDescription: jobDescription,
          jobGroups: jobGroups,
          jobModelMemoryLimit: jobModelMemoryLimit,
          jobModelSnapshotRetentionDays: jobModelSnapshotRetentionDays,
          jobDailyModelSnapshotRetentionAfterDays: jobDailyModelSnapshotRetentionAfterDays,
          setJobDetails: this.setJobDetails,
          jobGroupsValidationError: jobGroupsValidationError,
          jobModelMemoryLimitValidationError: jobModelMemoryLimitValidationError,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 348,
            columnNumber: 13
          }
        })
      }, {
        id: 'detectors',
        'data-test-subj': 'mlEditJobFlyout-detectors',
        name: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.detectorsTitle', {
          defaultMessage: 'Detectors'
        }),
        content: /*#__PURE__*/_react.default.createElement(_tabs.EditDetectorsTab, {
          jobDetectors: jobDetectors,
          jobDetectorDescriptions: jobDetectorDescriptions,
          setDetectorDescriptions: this.setDetectorDescriptions,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 370,
            columnNumber: 13
          }
        })
      }, {
        id: 'datafeed',
        'data-test-subj': 'mlEditJobFlyout-datafeed',
        name: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.datafeedTitle', {
          defaultMessage: 'Datafeed'
        }),
        content: /*#__PURE__*/_react.default.createElement(_tabs.EditDatafeedTab, {
          datafeedQuery: datafeedQuery,
          datafeedQueryDelay: datafeedQueryDelay,
          datafeedFrequency: datafeedFrequency,
          datafeedScrollSize: datafeedScrollSize,
          jobBucketSpan: jobBucketSpan,
          setDatafeed: this.setDatafeed,
          datafeedRunning: datafeedRunning,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 384,
            columnNumber: 13
          }
        })
      }, {
        id: 'custom-urls',
        'data-test-subj': 'mlEditJobFlyout-customUrls',
        name: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.customUrlsTitle', {
          defaultMessage: 'Custom URLs'
        }),
        content: /*#__PURE__*/_react.default.createElement(_custom_urls.CustomUrlsWrapper, {
          job: job,
          jobCustomUrls: jobCustomUrls,
          setCustomUrls: this.setCustomUrls,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 402,
            columnNumber: 13
          }
        })
      }];
      flyout = /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
        onClose: () => {
          this.closeFlyout();
        },
        size: "m",
        "data-test-subj": "mlJobEditFlyout",
        "aria-label": _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.ariaLabel', {
          defaultMessage: 'Edit job flyout'
        }),
        focusTrapProps: (0, _create_focus_trap_props.createJobActionFocusTrapProps)(job.job_id),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 412,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 423,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 424,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 425,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.pageTitle",
        defaultMessage: "Edit {jobId}",
        values: {
          jobId: job.job_id
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 426,
          columnNumber: 17
        }
      }))), (0, _jobs_utils.isManagedJob)(job) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 436,
          columnNumber: 17
        }
      }), /*#__PURE__*/_react.default.createElement(_managed_jobs_warning_callout.ManagedJobsWarningCallout, {
        jobsCount: 1,
        action: _i18n.i18n.translate('xpack.ml.jobsList.editJobModal.editManagedJobDescription', {
          defaultMessage: 'editing'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 437,
          columnNumber: 17
        }
      })) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 449,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
        tabs: tabs,
        initialSelectedTab: tabs[0],
        onTabClick: () => {},
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 450,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 452,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        justifyContent: "spaceBetween",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 453,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 454,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "cross",
        onClick: () => {
          this.closeFlyout();
        },
        flush: "left",
        "data-test-subj": "mlEditJobFlyoutCloseButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 455,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.closeButtonLabel",
        defaultMessage: "Close",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 463,
          columnNumber: 19
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 469,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        onClick: this.save,
        fill: true,
        isDisabled: isValidJobDetails === false || isValidJobCustomUrls === false,
        "data-test-subj": "mlEditJobFlyoutSaveButton",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 470,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.saveButtonLabel",
        defaultMessage: "Save",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 476,
          columnNumber: 19
        }
      }))))));
    }
    if (this.state.isConfirmationModalVisible) {
      const returnFocus = (0, _create_focus_restoration.createJobActionFocusRestoration)(this.state.job.job_id);
      confirmationModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "aria-labelledby": confirmModalTitleId,
        title: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.unsavedChangesDialogTitle', {
          defaultMessage: 'Save changes before leaving?'
        }),
        titleProps: {
          id: confirmModalTitleId
        },
        onCancel: () => {
          this.closeFlyout(true);
          returnFocus();
        },
        onConfirm: () => {
          this.save();
          returnFocus();
        },
        cancelButtonText: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.leaveAnywayButtonLabel', {
          defaultMessage: 'Leave anyway'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.ml.jobsList.editJobFlyout.saveChangesButtonLabel', {
          defaultMessage: 'Save changes'
        }),
        defaultFocusedButton: "confirm",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 491,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 515,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.jobsList.editJobFlyout.unsavedChangesDialogMessage",
        defaultMessage: "If you don't save, your changes will be lost.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 516,
          columnNumber: 13
        }
      })));
    }
    {
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 527,
          columnNumber: 9
        }
      }, flyout, confirmationModal);
    }
  }
}
exports.EditJobFlyoutUI = EditJobFlyoutUI;
EditJobFlyoutUI.propTypes = {
  euiTheme: _propTypes.default.object.isRequired,
  setShowFunction: _propTypes.default.func.isRequired,
  unsetShowFunction: _propTypes.default.func.isRequired,
  refreshJobs: _propTypes.default.func.isRequired,
  allJobIds: _propTypes.default.array.isRequired
};
const EditJobFlyout = exports.EditJobFlyout = (0, _public.withKibana)(EditJobFlyoutUI);