"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStopAnalytics = void 0;
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../contexts/kibana");
var _toast_notification_service = require("../../../../../services/toast_notification_service");
var _common = require("../../../../common");
var _common2 = require("../../components/analytics_list/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStopAnalytics = () => {
  const toastNotificationService = (0, _toast_notification_service.useToastNotificationService)();
  const mlApi = (0, _kibana.useMlApi)();
  return async d => {
    try {
      await mlApi.dataFrameAnalytics.stopDataFrameAnalytics(d.config.id, (0, _common2.isDataFrameAnalyticsFailed)(d.stats.state));
      toastNotificationService.displaySuccessToast(_i18n.i18n.translate('xpack.ml.dataframe.analyticsList.stopAnalyticsSuccessMessage', {
        defaultMessage: 'Request to stop data frame analytics {analyticsId} acknowledged.',
        values: {
          analyticsId: d.config.id
        }
      }));
    } catch (e) {
      toastNotificationService.displayErrorToast(e, _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.stopAnalyticsErrorMessage', {
        defaultMessage: 'An error occurred stopping the data frame analytics {analyticsId}: {error}',
        values: {
          analyticsId: d.config.id,
          error: JSON.stringify(e)
        }
      }));
    }
    _common.refreshAnalyticsList$.next(_common.REFRESH_ANALYTICS_LIST_STATE.REFRESH);
  };
};
exports.useStopAnalytics = useStopAnalytics;