"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOptionsForJobSelectorMenuItems = void 0;
var _i18n = require("@kbn/i18n");
var _locator = require("../../../../locator");
var _job_details_flyout_context = require("../../../jobs/components/job_details_flyout/job_details_flyout_context");
var _locator2 = require("../../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANOMALY_EXPLORER_TITLE = _i18n.i18n.translate('xpack.ml.anomalyExplorerPageLabel', {
  defaultMessage: 'Anomaly Explorer'
});
const SINGLE_METRIC_VIEWER_TITLE = _i18n.i18n.translate('xpack.ml.singleMetricViewerPageLabel', {
  defaultMessage: 'Single Metric Viewer'
});
const getOptionsForJobSelectorMenuItems = ({
  jobId,
  page,
  onRemoveJobId,
  removeJobIdDisabled,
  showRemoveJobId,
  isSingleMetricViewerDisabled,
  closePopover,
  globalState,
  setActiveFlyout,
  setActiveJobId,
  navigateToUrl,
  share
}) => {
  const pageToNavigateTo = page === _locator.ML_PAGES.SINGLE_METRIC_VIEWER ? ANOMALY_EXPLORER_TITLE : SINGLE_METRIC_VIEWER_TITLE;
  const viewInMenu = {
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.jobContextMenu.viewInSingleMetricViewer', {
      defaultMessage: 'View in {page}',
      values: {
        page: pageToNavigateTo
      }
    }),
    disabled: page === _locator.ML_PAGES.ANOMALY_EXPLORER && isSingleMetricViewerDisabled,
    icon: 'visLine',
    onClick: async () => {
      const mlLocator = share.url.locators.get(_locator2.ML_APP_LOCATOR);
      if (!mlLocator) {
        return;
      }
      const singleMetricViewerLink = await mlLocator.getUrl({
        page: page === _locator.ML_PAGES.SINGLE_METRIC_VIEWER ? _locator.ML_PAGES.ANOMALY_EXPLORER : _locator.ML_PAGES.SINGLE_METRIC_VIEWER,
        pageState: {
          globalState,
          refreshInterval: {
            display: 'Off',
            pause: true,
            value: 0
          },
          jobIds: [jobId],
          query: {
            query_string: {
              analyze_wildcard: true,
              query: '*'
            }
          }
        }
      }, {
        absolute: true
      });
      navigateToUrl(singleMetricViewerLink);
      closePopover();
    }
  };
  const items = [{
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.jobContextMenu.jobDetails', {
      defaultMessage: 'Job details'
    }),
    icon: 'eye',
    onClick: () => {
      setActiveJobId(jobId);
      setActiveFlyout(_job_details_flyout_context.FlyoutType.JOB_DETAILS);
      closePopover();
    }
  }, ...(showRemoveJobId ? [{
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.jobContextMenu.removeJob', {
      defaultMessage: 'Remove from {page}',
      values: {
        page: ANOMALY_EXPLORER_TITLE
      }
    }),
    disabled: removeJobIdDisabled,
    icon: 'minusInCircle',
    onClick: () => {
      if (onRemoveJobId) {
        onRemoveJobId([jobId]);
        setActiveJobId(jobId);
        setActiveFlyout(null);
      }
      closePopover();
    }
  }] : []), {
    isSeparator: true,
    key: 'separator2'
  }, ...(viewInMenu.disabled ? [] : [viewInMenu]), {
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.jobContextMenu.viewDatafeedCounts', {
      defaultMessage: 'View datafeed counts'
    }),
    icon: 'visAreaStacked',
    onClick: () => {
      setActiveJobId(jobId);
      setActiveFlyout(_job_details_flyout_context.FlyoutType.DATAFEED_CHART);
      closePopover();
    }
  }];
  return items;
};
exports.getOptionsForJobSelectorMenuItems = getOptionsForJobSelectorMenuItems;