"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.diskIO = void 0;
var _i18n = require("@kbn/i18n");
var _formulas = require("../formulas");
var _constants = require("../../../shared/charts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const dockerContainerDiskIOReadWrite = {
  id: 'diskIOReadWrite',
  chartType: 'xy',
  title: _constants.DISK_IOPS_LABEL,
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [{
      ..._formulas.formulas.dockerContainerDiskIORead,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.read', {
        defaultMessage: 'Read'
      })
    }, {
      ..._formulas.formulas.dockerContainerDiskIOWrite,
      label: _i18n.i18n.translate('xpack.metricsData.assetDetails.metricsCharts.metric.label.write', {
        defaultMessage: 'Write'
      })
    }]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const diskIO = exports.diskIO = {
  xy: {
    dockerContainerDiskIOReadWrite
  }
};