"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.settingsSchema = exports.customIconSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const customIconSchema = exports.customIconSchema = _configSchema.schema.object({
  symbolId: _configSchema.schema.string(),
  svg: _configSchema.schema.string(),
  label: _configSchema.schema.string(),
  cutoff: _configSchema.schema.number(),
  radius: _configSchema.schema.number()
});
const settingsSchema = exports.settingsSchema = _configSchema.schema.object({
  autoFitToDataBounds: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  backgroundColor: _configSchema.schema.maybe(_configSchema.schema.string()),
  customIcons: _configSchema.schema.maybe(_configSchema.schema.arrayOf(customIconSchema)),
  disableInteractive: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  disableTooltipControl: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  hideToolbarOverlay: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  hideLayerControl: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  hideViewControl: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  initialLocation: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(_common.INITIAL_LOCATION.LAST_SAVED_LOCATION), _configSchema.schema.literal(_common.INITIAL_LOCATION.FIXED_LOCATION), _configSchema.schema.literal(_common.INITIAL_LOCATION.BROWSER_LOCATION), _configSchema.schema.literal(_common.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS)])),
  fixedLocation: _configSchema.schema.maybe(_configSchema.schema.object({
    lat: _configSchema.schema.number(),
    lon: _configSchema.schema.number(),
    zoom: _configSchema.schema.number()
  })),
  browserLocation: _configSchema.schema.maybe(_configSchema.schema.object({
    zoom: _configSchema.schema.number()
  })),
  keydownScrollZoom: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  maxZoom: _configSchema.schema.maybe(_configSchema.schema.number()),
  minZoom: _configSchema.schema.maybe(_configSchema.schema.number()),
  projection: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('globeInterpolate'), _configSchema.schema.literal('mercator')])),
  showScaleControl: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  showSpatialFilters: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  showTimesliderToggleButton: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  spatialFiltersAlpa: _configSchema.schema.maybe(_configSchema.schema.number()),
  spatialFiltersFillColor: _configSchema.schema.maybe(_configSchema.schema.string()),
  spatialFiltersLineColor: _configSchema.schema.maybe(_configSchema.schema.string())
});