"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureCatalogueEntry = void 0;
var _i18n = require("@kbn/i18n");
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const featureCatalogueEntry = exports.featureCatalogueEntry = {
  id: _constants.APP_ID,
  title: _constants.APP_NAME,
  subtitle: _i18n.i18n.translate('xpack.maps.featureCatalogue.mapsSubtitle', {
    defaultMessage: 'Plot geographic data.'
  }),
  description: _i18n.i18n.translate('xpack.maps.feature.appDescription', {
    defaultMessage: 'Explore geospatial data from Elasticsearch and the Elastic Maps Service.'
  }),
  icon: _constants.APP_ICON,
  path: '/app/maps',
  showOnHomePage: false,
  category: 'data',
  solutionId: 'kibana',
  order: 400
};