"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolsControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
var _geometry_filter_form = require("../../../components/draw_forms/geometry_filter_form/geometry_filter_form");
var _distance_filter_form = require("../../../components/draw_forms/distance_filter_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/toolbar_overlay/tools_control/tools_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DRAW_SHAPE_LABEL = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawShapeLabel', {
  defaultMessage: 'Draw shape to filter data'
});
const DRAW_BOUNDS_LABEL = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawBoundsLabel', {
  defaultMessage: 'Draw bounds to filter data'
});
const DRAW_DISTANCE_LABEL = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawDistanceLabel', {
  defaultMessage: 'Draw distance to filter data'
});
const DRAW_SHAPE_LABEL_SHORT = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawShapeLabelShort', {
  defaultMessage: 'Draw shape'
});
const DRAW_BOUNDS_LABEL_SHORT = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawBoundsLabelShort', {
  defaultMessage: 'Draw bounds'
});
const DRAW_DISTANCE_LABEL_SHORT = _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawDistanceLabelShort', {
  defaultMessage: 'Draw distance'
});
class ToolsControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isPopoverOpen: false
    });
    (0, _defineProperty2.default)(this, "_togglePopover", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "_closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
      if (this.props.filterModeActive) {
        this.props.cancelDraw();
      }
    });
    (0, _defineProperty2.default)(this, "_initiateShapeDraw", options => {
      this.props.initiateDraw({
        drawShape: _constants.DRAW_SHAPE.POLYGON,
        ...options
      });
      this._closePopover();
    });
    (0, _defineProperty2.default)(this, "_initiateBoundsDraw", options => {
      this.props.initiateDraw({
        drawShape: _constants.DRAW_SHAPE.BOUNDS,
        ...options
      });
      this._closePopover();
    });
    (0, _defineProperty2.default)(this, "_initiateDistanceDraw", options => {
      this.props.initiateDraw({
        drawShape: _constants.DRAW_SHAPE.DISTANCE,
        ...options
      });
      this._closePopover();
    });
  }
  _getDrawPanels() {
    const tools = [{
      name: DRAW_SHAPE_LABEL,
      panel: 1
    }, {
      name: DRAW_BOUNDS_LABEL,
      panel: 2
    }, {
      name: DRAW_DISTANCE_LABEL,
      panel: 3
    }];
    return [{
      id: 0,
      title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.tools.toolbarTitle', {
        defaultMessage: 'Tools'
      }),
      items: tools
    }, {
      id: 1,
      title: DRAW_SHAPE_LABEL_SHORT,
      content: /*#__PURE__*/_react.default.createElement(_geometry_filter_form.GeometryFilterForm, {
        className: "mapDrawControl__geometryFilterForm",
        buttonLabel: DRAW_SHAPE_LABEL_SHORT,
        getFilterActions: this.props.getFilterActions,
        getActionContext: this.props.getActionContext,
        intitialGeometryLabel: _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawShape.initialGeometryLabel', {
          defaultMessage: 'shape'
        }),
        onSubmit: this._initiateShapeDraw,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 11
        }
      })
    }, {
      id: 2,
      title: DRAW_BOUNDS_LABEL_SHORT,
      content: /*#__PURE__*/_react.default.createElement(_geometry_filter_form.GeometryFilterForm, {
        className: "mapDrawControl__geometryFilterForm",
        buttonLabel: DRAW_BOUNDS_LABEL_SHORT,
        getFilterActions: this.props.getFilterActions,
        getActionContext: this.props.getActionContext,
        intitialGeometryLabel: _i18n.i18n.translate('xpack.maps.toolbarOverlay.drawBounds.initialGeometryLabel', {
          defaultMessage: 'bounds'
        }),
        onSubmit: this._initiateBoundsDraw,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 11
        }
      })
    }, {
      id: 3,
      title: DRAW_DISTANCE_LABEL_SHORT,
      content: /*#__PURE__*/_react.default.createElement(_distance_filter_form.DistanceFilterForm, {
        className: "mapDrawControl__geometryFilterForm",
        buttonLabel: DRAW_DISTANCE_LABEL_SHORT,
        getFilterActions: this.props.getFilterActions,
        getActionContext: this.props.getActionContext,
        onSubmit: this._initiateDistanceDraw,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 190,
          columnNumber: 11
        }
      })
    }];
  }
  _renderToolsButton() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "none",
      className: "mapToolbarOverlay__button",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      className: "mapToolbarOverlay__buttonIcon-empty",
      size: "s",
      color: "text",
      iconType: "wrench",
      onClick: this._togglePopover,
      "aria-label": _i18n.i18n.translate('xpack.maps.toolbarOverlay.toolsControlTitle', {
        defaultMessage: 'Tools'
      }),
      title: _i18n.i18n.translate('xpack.maps.toolbarOverlay.toolsControlTitle', {
        defaultMessage: 'Tools'
      }),
      isDisabled: this.props.disableToolsControl,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 9
      }
    }));
  }
  render() {
    const toolsPopoverButton = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "toolsControlPopover",
      button: this._renderToolsButton(),
      isOpen: this.state.isPopoverOpen,
      closePopover: this._closePopover,
      panelPaddingSize: "none",
      anchorPosition: "leftUp",
      "data-test-subj": "mapToolsControlPopover",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: this._getDrawPanels(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 9
      }
    }));
    if (!this.props.filterModeActive) {
      return toolsPopoverButton;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 9
      }
    }, toolsPopoverButton), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      size: "s",
      fill: true,
      onClick: this.props.cancelDraw,
      autoFocus: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.tooltip.toolsControl.cancelDrawButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 247,
        columnNumber: 13
      }
    }))));
  }
}
exports.ToolsControl = ToolsControl;