"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FitToData = void 0;
var _reactRedux = require("react-redux");
var _actions = require("../../../actions");
var _map_selectors = require("../../../selectors/map_selectors");
var _fit_to_data = require("./fit_to_data");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mapStateToProps(state) {
  const mapSettings = (0, _map_selectors.getMapSettings)(state);
  return {
    autoFitToDataBounds: mapSettings.autoFitToDataBounds
  };
}
function mapDispatchToProps(dispatch) {
  return {
    fitToBounds: () => {
      dispatch((0, _actions.fitToDataBounds)());
    }
  };
}
const connectedFitToData = exports.FitToData = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_fit_to_data.FitToData);