"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TileErrorsList = TileErrorsList;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _searchErrors = require("@kbn/search-errors");
var _kibana_services = require("../../kibana_services");
var _vector_tile_inspector = require("../../inspector/vector_tile_adapter/components/vector_tile_inspector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/layers/tile_errors_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TileErrorsList(props) {
  const [selectedTileError, setSelectedTileError] = (0, _react.useState)(undefined);
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const hasSelectedTileError = selectedTileError && props.tileErrors.some(({
      tileKey
    }) => {
      return tileKey === selectedTileError.tileKey;
    });
    if (!hasSelectedTileError) {
      var _props$tileErrors;
      setSelectedTileError((_props$tileErrors = props.tileErrors) === null || _props$tileErrors === void 0 ? void 0 : _props$tileErrors[0]);
    }
  }, [props.tileErrors, selectedTileError]);
  if (props.tileErrors.length === 0 || !selectedTileError) {
    return null;
  }
  const panels = [{
    id: 0,
    items: props.tileErrors.map(tileError => {
      return {
        name: getTitle(tileError.tileKey),
        onClick: () => {
          const nextTileError = props.tileErrors.find(({
            tileKey
          }) => {
            return tileKey === tileError.tileKey;
          });
          setSelectedTileError(nextTileError);
          setIsPopoverOpen(false);
        }
      };
    })
  }];
  function renderError(tileError) {
    if (!props.isESVectorTileSource || !tileError.error) {
      return tileError.message;
    }
    const esError = (0, _searchErrors.createEsError)({
      statusCode: 400,
      message: tileError.message,
      attributes: {
        error: tileError.error
      }
    }, () => {
      (0, _kibana_services.getInspector)().open(props.inspectorAdapters, {
        options: {
          initialLayerId: props.layerId,
          initialTileKey: tileError.tileKey,
          initialTab: [_vector_tile_inspector.RESPONSE_VIEW_ID]
        }
      });
    }, {
      application: (0, _kibana_services.getApplication)(),
      docLinks: (0, _kibana_services.getDocLinks)()
    });
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, esError.getErrorMessage(), esError.getActions());
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "tileErrorsPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "left",
      iconType: "arrowDown",
      iconSide: "right",
      onClick: () => {
        setIsPopoverOpen(!isPopoverOpen);
      },
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 11
      }
    }, getTitle(selectedTileError.tileKey)),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 9
    }
  })), renderError(selectedTileError));
}
function getTitle(tileKey) {
  return _i18n.i18n.translate('xpack.maps.tileError.title', {
    defaultMessage: `tile {tileKey}`,
    values: {
      tileKey
    }
  });
}